/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.basic;

import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.util.collections.BimodalMap;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.collections.SmallMap;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.BFSPathFinder;
import com.ibm.wala.util.graph.traverse.BoundedBFSIterator;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BimodalMutableIntSetFactory;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.BitVectorIntSetFactory;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.IntegerUnionFind;
import com.ibm.wala.util.intset.LongSet;
import com.ibm.wala.util.intset.LongSetUtil;
import com.ibm.wala.util.intset.MutableIntSetFactory;
import com.ibm.wala.util.intset.MutableLongSet;
import com.ibm.wala.util.intset.MutableLongSetFactory;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.MutableSparseLongSetFactory;
import com.ibm.wala.util.intset.OffsetBitVector;
import com.ibm.wala.util.intset.SemiSparseMutableIntSet;
import com.ibm.wala.util.intset.SemiSparseMutableIntSetFactory;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.intset.SparseLongSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PrimitivesTest
extends WalaTestCase {
    private void doMutableIntSet(MutableIntSetFactory factory) {
        int xx;
        Object v = factory.parse("{9,17}");
        Object w = factory.make(new int[0]);
        Object x = factory.make(new int[]{7, 4, 2, 4, 2, 2});
        Object y = factory.make(new int[]{7, 7, 7, 2, 7, 1});
        Object z = factory.parse("{ 9 }");
        System.err.println(w);
        System.err.println(x);
        System.err.println(y);
        System.err.println(z);
        Object temp = factory.makeCopy((IntSet)x);
        temp.intersectWith((IntSet)y);
        System.err.println(temp);
        temp.copySet((IntSet)x);
        temp.addAll((IntSet)y);
        System.err.println(temp);
        temp.copySet((IntSet)x);
        System.err.println(IntSetUtil.diff(x, y, factory));
        System.err.println(IntSetUtil.diff(v, z, factory));
        System.err.println(IntSetUtil.diff(z, v, factory));
        Object temp1 = factory.makeCopy((IntSet)x);
        Object temp2 = factory.makeCopy((IntSet)x);
        Object tempY = factory.makeCopy((IntSet)y);
        temp1.addAll((IntSet)z);
        tempY.addAll((IntSet)z);
        temp1.intersectWith((IntSet)tempY);
        temp2.intersectWith((IntSet)y);
        temp2.addAll((IntSet)z);
        Assert.assertTrue((boolean)temp1.sameValue((IntSet)temp2));
        Assert.assertTrue((boolean)w.isEmpty());
        Assert.assertTrue((boolean)IntSetUtil.diff(x, x, factory).isEmpty());
        Assert.assertTrue((boolean)IntSetUtil.diff(z, v, factory).isEmpty());
        Assert.assertTrue((boolean)IntSetUtil.diff(v, z, factory).sameValue(SparseIntSet.singleton(17)));
        Assert.assertTrue((boolean)IntSetUtil.diff(z, v, factory).isEmpty());
        Assert.assertTrue((boolean)z.isSubset((IntSet)v));
        temp = factory.make();
        temp.add(4);
        System.err.println(temp);
        temp.add(7);
        System.err.println(temp);
        temp.add(2);
        System.err.println(temp);
        System.err.println(x);
        Assert.assertTrue((boolean)temp.sameValue((IntSet)x));
        Object a = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59}");
        System.err.println(a);
        Assert.assertTrue((boolean)a.sameValue((IntSet)a));
        IntSet i = a.intersection((IntSet)temp);
        Assert.assertTrue((boolean)i.sameValue(SparseIntSet.singleton(7)));
        a.add(100);
        Assert.assertTrue((boolean)a.sameValue((IntSet)a));
        Object b = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,100}");
        Assert.assertTrue((boolean)a.sameValue((IntSet)b));
        Assert.assertTrue((boolean)a.isSubset((IntSet)b));
        IntSet f = IntSetUtil.diff(b, factory.parse("{7,8,9}"), factory);
        System.err.println(f);
        Assert.assertFalse((boolean)f.contains(7));
        Assert.assertFalse((boolean)f.contains(8));
        Assert.assertFalse((boolean)f.contains(9));
        Assert.assertFalse((boolean)f.sameValue((IntSet)b));
        Assert.assertTrue((boolean)f.isSubset((IntSet)b));
        Object tmp = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,51,53,55,57,59,61,63}");
        f = IntSetUtil.diff(b, tmp, factory);
        System.err.println(f);
        Assert.assertFalse((boolean)f.sameValue((IntSet)b));
        Assert.assertTrue((boolean)f.isSubset((IntSet)b));
        Assert.assertFalse((boolean)f.contains(51));
        Assert.assertFalse((boolean)f.contains(53));
        Assert.assertFalse((boolean)f.contains(55));
        Assert.assertFalse((boolean)f.contains(57));
        Assert.assertFalse((boolean)f.contains(59));
        Assert.assertTrue((boolean)f.contains(100));
        tmp = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,51,53,55,57,59,61,63,100}");
        f = IntSetUtil.diff(b, tmp, factory);
        System.err.println(f);
        Assert.assertFalse((boolean)f.sameValue((IntSet)b));
        Assert.assertTrue((boolean)f.isSubset((IntSet)b));
        Assert.assertFalse((boolean)f.contains(51));
        Assert.assertFalse((boolean)f.contains(53));
        Assert.assertFalse((boolean)f.contains(55));
        Assert.assertFalse((boolean)f.contains(57));
        Assert.assertFalse((boolean)f.contains(59));
        Assert.assertFalse((boolean)f.contains(100));
        b = factory.makeCopy((IntSet)a);
        Assert.assertTrue((boolean)a.sameValue((IntSet)b));
        b.remove(1);
        b.add(0);
        Assert.assertTrue((!a.sameValue((IntSet)b) ? 1 : 0) != 0);
        a = factory.parse("{1}");
        Assert.assertFalse((boolean)a.isSubset((IntSet)b));
        b.remove(0);
        Assert.assertFalse((boolean)a.isSubset((IntSet)b));
        a.remove(1);
        Assert.assertTrue((boolean)a.isEmpty());
        i = a.intersection((IntSet)temp);
        Assert.assertTrue((boolean)a.isEmpty());
        temp2 = factory.make();
        Assert.assertTrue((boolean)temp2.sameValue((IntSet)a));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,51,53,55,57,59,61,63}");
        b = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62}");
        Object c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        Object d = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        Object e = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34}");
        Assert.assertTrue((boolean)e.isSubset((IntSet)d));
        e.addAll((IntSet)d);
        Assert.assertTrue((boolean)e.isSubset((IntSet)d));
        e.remove(12);
        Assert.assertTrue((boolean)e.isSubset((IntSet)d));
        e.add(105);
        Assert.assertFalse((boolean)e.isSubset((IntSet)d));
        Assert.assertFalse((boolean)b.isSubset((IntSet)a));
        b.add(53);
        Assert.assertFalse((boolean)b.isSubset((IntSet)a));
        a.add(52);
        a.remove(52);
        Assert.assertFalse((boolean)b.isSubset((IntSet)a));
        c.add(55);
        Assert.assertFalse((boolean)c.isSubset((IntSet)b));
        d.add(53);
        Assert.assertTrue((boolean)d.isSubset((IntSet)b));
        d = factory.make();
        d.copySet((IntSet)c);
        Assert.assertFalse((boolean)d.isSubset((IntSet)b));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        b = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48}");
        Assert.assertFalse((boolean)a.sameValue((IntSet)b));
        b.add(50);
        Assert.assertTrue((boolean)a.sameValue((IntSet)b));
        a.add(11);
        b.add(11);
        Assert.assertTrue((boolean)a.sameValue((IntSet)b));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,50}");
        b = factory.parse("{24,26,28,30,32,34,36,38,40,42,44,46,48}");
        c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        a.addAll((IntSet)b);
        a.add(22);
        Assert.assertTrue((boolean)a.sameValue((IntSet)c));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,50}");
        b = factory.parse("{24,26,28,30,32,34,36,38,40,42,44,46,48}");
        c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        b.addAll((IntSet)factory.parse("{22}"));
        a.addAll((IntSet)b);
        Assert.assertTrue((boolean)a.sameValue((IntSet)c));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20}");
        b = factory.parse("{22,24,26,28,30,32,34,36,38,40,42,44,46,48}");
        c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        c.remove(22);
        a.addAll((IntSet)b);
        Assert.assertFalse((boolean)a.sameValue((IntSet)c));
        a = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59}");
        System.err.println(a);
        Assert.assertTrue((boolean)a.sameValue((IntSet)a));
        i = a.intersection((IntSet)temp);
        Assert.assertTrue((boolean)i.sameValue(SparseIntSet.singleton(7)));
        a.add(100);
        Assert.assertTrue((boolean)a.sameValue((IntSet)a));
        b = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,100}");
        Assert.assertTrue((boolean)a.sameValue((IntSet)b));
        Assert.assertTrue((boolean)a.isSubset((IntSet)b));
        b = factory.makeCopy((IntSet)a);
        Assert.assertTrue((boolean)a.sameValue((IntSet)b));
        b.remove(1);
        b.add(0);
        Assert.assertTrue((!a.sameValue((IntSet)b) ? 1 : 0) != 0);
        a.clear();
        Assert.assertTrue((boolean)a.isEmpty());
        a = factory.parse("{1}");
        Assert.assertFalse((boolean)a.isSubset((IntSet)b));
        b.remove(0);
        Assert.assertFalse((boolean)a.isSubset((IntSet)b));
        a.remove(1);
        Assert.assertTrue((boolean)a.isEmpty());
        i = a.intersection((IntSet)temp);
        Assert.assertTrue((boolean)a.isEmpty());
        temp2 = factory.make();
        Assert.assertTrue((boolean)temp2.sameValue((IntSet)a));
        int idx = 500;
        while (idx < 550) {
            xx = 0;
            while (xx < 50) {
                temp2.add(idx);
                ++xx;
                ++idx;
            }
            System.err.println(temp2);
        }
        idx = 3000;
        while (idx < 3200) {
            xx = 0;
            while (xx < 50) {
                temp2.add(idx);
                ++xx;
                ++idx;
            }
            System.err.println(temp2);
        }
        temp2.clear();
        Assert.assertTrue((boolean)temp2.isEmpty());
        temp2 = factory.make();
        Assert.assertTrue((boolean)temp2.sameValue((IntSet)a));
        idx = 500;
        while (idx < 550) {
            xx = 0;
            while (xx < 50) {
                temp2.add(idx);
                ++xx;
                ++idx;
            }
            System.err.println(temp2);
        }
        idx = 0;
        while (idx < 25) {
            temp2.add(idx);
            System.err.println(temp2);
            ++idx;
        }
        temp2.clear();
        Assert.assertTrue((boolean)temp2.isEmpty());
    }

    @Test
    public void testMutableSharedBitVectorIntSet() {
        this.doMutableIntSet(new MutableSharedBitVectorIntSetFactory());
    }

    @Test
    public void testMutableSparseIntSet() {
        this.doMutableIntSet(new MutableSparseIntSetFactory());
    }

    @Test
    public void testBimodalMutableSparseIntSet() {
        this.doMutableIntSet(new BimodalMutableIntSetFactory());
    }

    @Test
    public void testBitVectorIntSet() {
        this.doMutableIntSet(new BitVectorIntSetFactory());
    }

    @Test
    public void testSemiSparseMutableIntSet() {
        this.doMutableIntSet(new SemiSparseMutableIntSetFactory());
    }

    private void doMutableLongSet(MutableLongSetFactory factory) {
        int xx;
        MutableLongSet v = factory.parse("{9,17}");
        MutableLongSet w = factory.make(new long[0]);
        MutableLongSet x = factory.make(new long[]{7L, 4L, 2L, 4L, 2L, 2L});
        MutableLongSet y = factory.make(new long[]{7L, 7L, 7L, 2L, 7L, 1L});
        MutableLongSet z = factory.parse("{ 9 }");
        System.err.println(w);
        System.err.println(x);
        System.err.println(y);
        System.err.println(z);
        MutableLongSet temp = factory.makeCopy(x);
        temp.intersectWith(y);
        System.err.println(temp);
        temp.copySet(x);
        temp.addAll(y);
        System.err.println(temp);
        temp.copySet(x);
        System.err.println(LongSetUtil.diff(x, y, factory));
        System.err.println(LongSetUtil.diff(v, z, factory));
        System.err.println(LongSetUtil.diff(z, v, factory));
        MutableLongSet temp1 = factory.makeCopy(x);
        MutableLongSet temp2 = factory.makeCopy(x);
        MutableLongSet tempY = factory.makeCopy(y);
        temp1.addAll(z);
        tempY.addAll(z);
        temp1.intersectWith(tempY);
        temp2.intersectWith(y);
        temp2.addAll(z);
        Assert.assertTrue((boolean)temp1.sameValue(temp2));
        Assert.assertTrue((boolean)w.isEmpty());
        Assert.assertTrue((boolean)LongSetUtil.diff(x, x, factory).isEmpty());
        Assert.assertTrue((boolean)LongSetUtil.diff(z, v, factory).isEmpty());
        Assert.assertTrue((boolean)LongSetUtil.diff(v, z, factory).sameValue(SparseLongSet.singleton(17)));
        Assert.assertTrue((boolean)LongSetUtil.diff(z, v, factory).isEmpty());
        Assert.assertTrue((boolean)z.isSubset(v));
        temp = factory.make();
        temp.add(4L);
        System.err.println(temp);
        temp.add(7L);
        System.err.println(temp);
        temp.add(2L);
        System.err.println(temp);
        System.err.println(x);
        Assert.assertTrue((boolean)temp.sameValue(x));
        MutableLongSet a = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59}");
        System.err.println(a);
        Assert.assertTrue((boolean)a.sameValue(a));
        LongSet i = a.intersection(temp);
        Assert.assertTrue((boolean)i.sameValue(SparseLongSet.singleton(7)));
        a.add(100L);
        Assert.assertTrue((boolean)a.sameValue(a));
        MutableLongSet b = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,100}");
        Assert.assertTrue((boolean)a.sameValue(b));
        Assert.assertTrue((boolean)a.isSubset(b));
        LongSet f = LongSetUtil.diff(b, factory.parse("{7,8,9}"), factory);
        System.err.println(f);
        Assert.assertFalse((boolean)f.contains(7L));
        Assert.assertFalse((boolean)f.contains(8L));
        Assert.assertFalse((boolean)f.contains(9L));
        Assert.assertFalse((boolean)f.sameValue(b));
        Assert.assertTrue((boolean)f.isSubset(b));
        MutableLongSet tmp = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,51,53,55,57,59,61,63}");
        f = LongSetUtil.diff(b, tmp, factory);
        System.err.println(f);
        Assert.assertFalse((boolean)f.sameValue(b));
        Assert.assertTrue((boolean)f.isSubset(b));
        Assert.assertFalse((boolean)f.contains(51L));
        Assert.assertFalse((boolean)f.contains(53L));
        Assert.assertFalse((boolean)f.contains(55L));
        Assert.assertFalse((boolean)f.contains(57L));
        Assert.assertFalse((boolean)f.contains(59L));
        Assert.assertTrue((boolean)f.contains(100L));
        tmp = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,51,53,55,57,59,61,63,100}");
        f = LongSetUtil.diff(b, tmp, factory);
        System.err.println(f);
        Assert.assertFalse((boolean)f.sameValue(b));
        Assert.assertTrue((boolean)f.isSubset(b));
        Assert.assertFalse((boolean)f.contains(51L));
        Assert.assertFalse((boolean)f.contains(53L));
        Assert.assertFalse((boolean)f.contains(55L));
        Assert.assertFalse((boolean)f.contains(57L));
        Assert.assertFalse((boolean)f.contains(59L));
        Assert.assertFalse((boolean)f.contains(100L));
        b = factory.makeCopy(a);
        Assert.assertTrue((boolean)a.sameValue(b));
        b.remove(1L);
        b.add(0L);
        Assert.assertTrue((!a.sameValue(b) ? 1 : 0) != 0);
        a = factory.parse("{1}");
        Assert.assertFalse((boolean)a.isSubset(b));
        b.remove(0L);
        Assert.assertFalse((boolean)a.isSubset(b));
        a.remove(1L);
        Assert.assertTrue((boolean)a.isEmpty());
        i = a.intersection(temp);
        Assert.assertTrue((boolean)a.isEmpty());
        temp2 = factory.make();
        Assert.assertTrue((boolean)temp2.sameValue(a));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,51,53,55,57,59,61,63}");
        b = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62}");
        MutableLongSet c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        MutableLongSet d = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        MutableLongSet e = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34}");
        Assert.assertTrue((boolean)e.isSubset(d));
        e.addAll(d);
        Assert.assertTrue((boolean)e.isSubset(d));
        e.remove(12L);
        Assert.assertTrue((boolean)e.isSubset(d));
        e.add(105L);
        Assert.assertFalse((boolean)e.isSubset(d));
        Assert.assertFalse((boolean)b.isSubset(a));
        b.add(53L);
        Assert.assertFalse((boolean)b.isSubset(a));
        a.add(52L);
        a.remove(52L);
        Assert.assertFalse((boolean)b.isSubset(a));
        c.add(55L);
        Assert.assertFalse((boolean)c.isSubset(b));
        d.add(53L);
        Assert.assertTrue((boolean)d.isSubset(b));
        d = factory.make();
        d.copySet(c);
        Assert.assertFalse((boolean)d.isSubset(b));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        b = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48}");
        Assert.assertFalse((boolean)a.sameValue(b));
        b.add(50L);
        Assert.assertTrue((boolean)a.sameValue(b));
        a.add(11L);
        b.add(11L);
        Assert.assertTrue((boolean)a.sameValue(b));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,50}");
        b = factory.parse("{24,26,28,30,32,34,36,38,40,42,44,46,48}");
        c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        a.addAll(b);
        a.add(22L);
        Assert.assertTrue((boolean)a.sameValue(c));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20,50}");
        b = factory.parse("{24,26,28,30,32,34,36,38,40,42,44,46,48}");
        c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        b.addAll(factory.parse("{22}"));
        a.addAll(b);
        Assert.assertTrue((boolean)a.sameValue(c));
        a = factory.parse("{2,4,6,8,10,12,14,16,18,20}");
        b = factory.parse("{22,24,26,28,30,32,34,36,38,40,42,44,46,48}");
        c = factory.parse("{2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50}");
        c.remove(22L);
        a.addAll(b);
        Assert.assertFalse((boolean)a.sameValue(c));
        a = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59}");
        System.err.println(a);
        Assert.assertTrue((boolean)a.sameValue(a));
        i = a.intersection(temp);
        Assert.assertTrue((boolean)i.sameValue(SparseLongSet.singleton(7)));
        a.add(100L);
        Assert.assertTrue((boolean)a.sameValue(a));
        b = factory.parse("{1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,100}");
        Assert.assertTrue((boolean)a.sameValue(b));
        Assert.assertTrue((boolean)a.isSubset(b));
        b = factory.makeCopy(a);
        Assert.assertTrue((boolean)a.sameValue(b));
        b.remove(1L);
        b.add(0L);
        Assert.assertTrue((!a.sameValue(b) ? 1 : 0) != 0);
        a = factory.parse("{1}");
        Assert.assertFalse((boolean)a.isSubset(b));
        b.remove(0L);
        Assert.assertFalse((boolean)a.isSubset(b));
        a.remove(1L);
        Assert.assertTrue((boolean)a.isEmpty());
        i = a.intersection(temp);
        Assert.assertTrue((boolean)a.isEmpty());
        temp2 = factory.make();
        Assert.assertTrue((boolean)temp2.sameValue(a));
        int idx = 500;
        while (idx < 550) {
            xx = 0;
            while (xx < 50) {
                temp2.add(idx);
                ++xx;
                ++idx;
            }
            System.err.println(temp2);
        }
        idx = 3000;
        while (idx < 3200) {
            xx = 0;
            while (xx < 50) {
                temp2.add(idx);
                ++xx;
                ++idx;
            }
            System.err.println(temp2);
        }
        temp2 = factory.make();
        Assert.assertTrue((boolean)temp2.sameValue(a));
        idx = 500;
        while (idx < 550) {
            xx = 0;
            while (xx < 50) {
                temp2.add(idx);
                ++xx;
                ++idx;
            }
            System.err.println(temp2);
        }
        idx = 0;
        while (idx < 25) {
            temp2.add(idx);
            System.err.println(temp2);
            ++idx;
        }
    }

    @Test
    public void testMutableSparseLongSet() {
        this.doMutableLongSet(new MutableSparseLongSetFactory());
    }

    @Test
    public void testSmallMap() {
        SmallMap M = new SmallMap();
        Integer I1 = new Integer(1);
        Integer I2 = new Integer(2);
        Integer I3 = new Integer(3);
        M.put(I1, I1);
        M.put(I2, I2);
        M.put(I3, I3);
        Integer I = (Integer)M.get(new Integer(2));
        Assert.assertTrue((I != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)I.equals(I2));
        I = (Integer)M.get(new Integer(4));
        Assert.assertTrue((I == null ? 1 : 0) != 0);
        I = (Integer)M.put(new Integer(2), new Integer(3));
        Assert.assertTrue((boolean)I.equals(I2));
        I = (Integer)M.get(I2);
        Assert.assertTrue((boolean)I.equals(I3));
    }

    @Test
    public void testBimodalMap() {
        BimodalMap<Integer, Integer> M = new BimodalMap<Integer, Integer>(3);
        Integer I1 = new Integer(1);
        Integer I2 = new Integer(2);
        Integer I3 = new Integer(3);
        Integer I4 = new Integer(4);
        Integer I5 = new Integer(5);
        Integer I6 = new Integer(6);
        M.put(I1, I1);
        M.put(I2, I2);
        M.put(I3, I3);
        Integer I = (Integer)M.get(new Integer(2));
        Assert.assertTrue((I != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)I.equals(I2));
        I = (Integer)M.get(new Integer(4));
        Assert.assertTrue((I == null ? 1 : 0) != 0);
        I = M.put(new Integer(2), new Integer(3));
        Assert.assertTrue((boolean)I.equals(I2));
        I = (Integer)M.get(I2);
        Assert.assertTrue((boolean)I.equals(I3));
        M.put(I4, I4);
        M.put(I5, I5);
        M.put(I6, I6);
        I = (Integer)M.get(new Integer(4));
        Assert.assertTrue((I != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)I.equals(I4));
        I = (Integer)M.get(new Integer(7));
        Assert.assertTrue((I == null ? 1 : 0) != 0);
        I = M.put(new Integer(2), new Integer(6));
        Assert.assertTrue((boolean)I.equals(I3));
        I = (Integer)M.get(I2);
        Assert.assertTrue((boolean)I.equals(I6));
    }

    @Test
    public void testBFSPathFinder() {
        NumberedGraph<Integer> G = this.makeBFSTestGraph();
        BFSPathFinder<Integer> pf = new BFSPathFinder<Integer>(G, (Integer)G.getNode(0), (Integer)G.getNode(8));
        List<Integer> p = pf.find();
        System.err.println("Path is " + p);
        int i = 0;
        while (i < p.size()) {
            int[] nArray = new int[5];
            nArray[0] = 8;
            nArray[1] = 6;
            nArray[2] = 4;
            nArray[3] = 2;
            Assert.assertTrue((p.get(i) == nArray[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testBoundedBFS() {
        NumberedGraph<Integer> G = this.makeBFSTestGraph();
        BoundedBFSIterator<Integer> bfs = new BoundedBFSIterator<Integer>(G, (Integer)G.getNode(0), 0);
        Iterator2Set<Integer> c = Iterator2Collection.toSet(bfs);
        Assert.assertTrue((c.size() == 1 ? 1 : 0) != 0);
        bfs = new BoundedBFSIterator<Integer>(G, (Integer)G.getNode(0), 1);
        c = Iterator2Collection.toSet(bfs);
        Assert.assertTrue((c.size() == 3 ? 1 : 0) != 0);
        bfs = new BoundedBFSIterator<Integer>(G, (Integer)G.getNode(0), 2);
        c = Iterator2Collection.toSet(bfs);
        Assert.assertTrue((c.size() == 5 ? 1 : 0) != 0);
        bfs = new BoundedBFSIterator<Integer>(G, (Integer)G.getNode(0), 3);
        c = Iterator2Collection.toSet(bfs);
        Assert.assertTrue((c.size() == 7 ? 1 : 0) != 0);
        bfs = new BoundedBFSIterator<Integer>(G, (Integer)G.getNode(0), 4);
        c = Iterator2Collection.toSet(bfs);
        Assert.assertTrue((c.size() == 9 ? 1 : 0) != 0);
        bfs = new BoundedBFSIterator<Integer>(G, (Integer)G.getNode(0), 5);
        c = Iterator2Collection.toSet(bfs);
        Assert.assertTrue((c.size() == 10 ? 1 : 0) != 0);
        bfs = new BoundedBFSIterator<Integer>(G, (Integer)G.getNode(0), 500);
        c = Iterator2Collection.toSet(bfs);
        Assert.assertTrue((c.size() == 10 ? 1 : 0) != 0);
    }

    private NumberedGraph<Integer> makeBFSTestGraph() {
        SlowSparseNumberedGraph<Integer> G = SlowSparseNumberedGraph.make();
        Integer[] nodes = new Integer[10];
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = new Integer(i);
            G.addNode(nodes[i]);
            ++i;
        }
        i = 0;
        while (i < nodes.length) {
            if (i > 0) {
                G.addEdge(nodes[i], nodes[i - 1]);
            }
            if (i < nodes.length - 1) {
                G.addEdge(nodes[i], nodes[i + 1]);
                if (i < nodes.length - 2) {
                    G.addEdge(nodes[i], nodes[i + 2]);
                }
            }
            ++i;
        }
        return G;
    }

    @Test
    public void testDominatorsA() {
        SlowSparseNumberedGraph<Object> G = SlowSparseNumberedGraph.make();
        Object[] nodes = new Object[11];
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = new Integer(i);
            G.addNode(nodes[i]);
            ++i;
        }
        G.addEdge(nodes[10], nodes[0]);
        G.addEdge(nodes[10], nodes[1]);
        G.addEdge(nodes[0], nodes[2]);
        G.addEdge(nodes[1], nodes[3]);
        G.addEdge(nodes[2], nodes[5]);
        G.addEdge(nodes[3], nodes[5]);
        G.addEdge(nodes[4], nodes[2]);
        G.addEdge(nodes[5], nodes[8]);
        G.addEdge(nodes[6], nodes[3]);
        G.addEdge(nodes[7], nodes[4]);
        G.addEdge(nodes[8], nodes[7]);
        G.addEdge(nodes[8], nodes[9]);
        G.addEdge(nodes[9], nodes[6]);
        Dominators<Object> D = Dominators.make(G, nodes[10]);
        int i2 = 0;
        Object[] desired4 = new Object[]{nodes[4], nodes[7], nodes[8], nodes[5], nodes[10]};
        Iterator<Object> d4 = D.dominators(nodes[4]);
        while (d4.hasNext()) {
            Assert.assertTrue((d4.next() == desired4[i2++] ? 1 : 0) != 0);
        }
        int j = 0;
        Object[] desired5 = new Object[]{nodes[8]};
        Iterator<Object> t4 = D.dominatorTree().getSuccNodes(nodes[5]);
        while (t4.hasNext()) {
            Object d;
            Object o4 = t4.next();
            boolean ok = o4.equals(d = desired5[j++]);
            if (ok) continue;
            System.err.println("O4: " + o4);
            System.err.println("desired " + d);
            Assert.assertTrue((boolean)o4.equals(d));
        }
        Assert.assertTrue((D.dominatorTree().getSuccNodeCount(nodes[10]) == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryIntegerRelation() {
        byte[] byArray = new byte[3];
        byArray[1] = 1;
        byte[] impl = byArray;
        BasicNaturalRelation R = new BasicNaturalRelation(impl, 1);
        R.add(3, 5);
        R.add(3, 7);
        R.add(3, 9);
        R.add(3, 11);
        R.add(5, 1);
        int count = 0;
        Iterator it = R.iterator();
        while (it.hasNext()) {
            System.err.println(it.next());
            ++count;
        }
        Assert.assertTrue((count == 5 ? 1 : 0) != 0);
        IntSet x = R.getRelated(3);
        Assert.assertTrue((x.size() == 4 ? 1 : 0) != 0);
        x = R.getRelated(5);
        Assert.assertTrue((x.size() == 1 ? 1 : 0) != 0);
        R.remove(5, 1);
        x = R.getRelated(5);
        Assert.assertTrue((x == null ? 1 : 0) != 0);
        R.add(2, 1);
        R.add(2, 2);
        R.remove(2, 1);
        x = R.getRelated(2);
        Assert.assertTrue((x.size() == 1 ? 1 : 0) != 0);
        R.removeAll(3);
        x = R.getRelated(3);
        Assert.assertTrue((x == null ? 1 : 0) != 0);
        x = R.getRelated(0);
        Assert.assertTrue((x == null ? 1 : 0) != 0);
        int i = 0;
        while (i < 100) {
            R.add(1, i);
            ++i;
        }
        Assert.assertTrue((R.getRelated(1).size() == 100 ? 1 : 0) != 0);
        R.remove(1, 1);
        Assert.assertTrue((R.getRelated(1).size() == 99 ? 1 : 0) != 0);
    }

    @Test
    public void testUnionFind() {
        int SIZE = 10000;
        IntegerUnionFind uf = new IntegerUnionFind(SIZE);
        int count = this.countEquivalenceClasses(uf);
        Assert.assertTrue((String)("Got count " + count), (count == SIZE ? 1 : 0) != 0);
        uf.union(3, 7);
        Assert.assertTrue((uf.find(3) == uf.find(7) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got uf.find(3)=" + uf.find(3)), (uf.find(3) == 3 || uf.find(3) == 7 ? 1 : 0) != 0);
        uf.union(7, SIZE - 1);
        Assert.assertTrue((uf.find(3) == uf.find(SIZE - 1) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got uf.find(3)=" + uf.find(3)), (uf.find(3) == 3 || uf.find(3) == 7 || uf.find(3) == SIZE - 1 ? 1 : 0) != 0);
        int i = 0;
        while (i < SIZE - 1) {
            uf.union(i, i + 1);
            ++i;
        }
        count = this.countEquivalenceClasses(uf);
        Assert.assertTrue((String)("Got count " + count), (count == 1 ? 1 : 0) != 0);
        uf = new IntegerUnionFind(SIZE);
        i = 0;
        while (i < SIZE) {
            if (i % 2 == 0) {
                uf.union(i, 0);
            } else {
                uf.union(i, 1);
            }
            ++i;
        }
        count = this.countEquivalenceClasses(uf);
        Assert.assertTrue((String)("Got count " + count), (count == 2 ? 1 : 0) != 0);
    }

    private int countEquivalenceClasses(IntegerUnionFind uf) {
        HashSet s = HashSetFactory.make();
        int i = 0;
        while (i < uf.size()) {
            s.add(new Integer(uf.find(i)));
            ++i;
        }
        return s.size();
    }

    @Test
    public void testBitVector() {
        this.testSingleBitVector(new BitVector());
    }

    @Test
    public void testOffsetBitVector0_10() {
        this.testSingleBitVector(new OffsetBitVector(0, 10));
    }

    @Test
    public void testOffsetBitVector10_10() {
        this.testSingleBitVector(new OffsetBitVector(10, 10));
    }

    @Test
    public void testOffsetBitVector50_10() {
        this.testSingleBitVector(new OffsetBitVector(50, 10));
    }

    @Test
    public void testOffsetBitVector50_50() {
        this.testSingleBitVector(new OffsetBitVector(50, 50));
    }

    @Test
    public void testOffsetBitVector100_10() {
        this.testSingleBitVector(new OffsetBitVector(100, 10));
    }

    private void testSingleBitVector(BitVectorBase bv) {
        bv.set(55);
        Assert.assertTrue((String)("bv.max() is " + bv.max()), (bv.max() == 55 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bv.get(55));
        bv.set(59);
        Assert.assertTrue((bv.max() == 59 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bv.get(55));
        Assert.assertTrue((boolean)bv.get(59));
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        boolean[] gets = blArray;
        int[] nArray = new int[3];
        nArray[1] = 55;
        nArray[2] = 59;
        int[] bits = nArray;
        int i = 0;
        int j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((bv.get(i) == gets[j] ? 1 : 0) != 0);
            i = bv.nextSetBit(i + 1);
            ++j;
        }
        bv.set(77);
        Assert.assertTrue((String)("bv.max() is " + bv.max()), (bv.max() == 77 ? 1 : 0) != 0);
        boolean[] blArray2 = new boolean[4];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        gets = blArray2;
        int[] nArray2 = new int[4];
        nArray2[1] = 55;
        nArray2[2] = 59;
        nArray2[3] = 77;
        bits = nArray2;
        i = 0;
        j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((bv.get(i) == gets[j] ? 1 : 0) != 0);
            i = bv.nextSetBit(i + 1);
            ++j;
        }
        bv.set(3);
        Assert.assertTrue((String)("bv.max() is " + bv.max()), (bv.max() == 77 ? 1 : 0) != 0);
        boolean[] blArray3 = new boolean[5];
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        gets = blArray3;
        int[] nArray3 = new int[5];
        nArray3[1] = 3;
        nArray3[2] = 55;
        nArray3[3] = 59;
        nArray3[4] = 77;
        bits = nArray3;
        i = 0;
        j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((bv.get(i) == gets[j] ? 1 : 0) != 0);
            i = bv.nextSetBit(i + 1);
            ++j;
        }
        System.err.println(bv);
    }

    @Test
    public void testBitVectors() {
        this.testBitVectors(new BitVector(), new BitVector());
    }

    @Test
    public void testOffsetBitVectors150_10() {
        this.testBitVectors(new OffsetBitVector(150, 10), new OffsetBitVector(150, 10));
    }

    @Test
    public void testOffsetBitVectors100_200_10() {
        this.testBitVectors(new OffsetBitVector(100, 10), new OffsetBitVector(200, 10));
    }

    @Test
    public void testOffsetBitVectors100_25_10() {
        this.testBitVectors(new OffsetBitVector(100, 10), new OffsetBitVector(25, 10));
    }

    @Test
    public void testOffsetBitVectors35_25_20_10() {
        this.testBitVectors(new OffsetBitVector(35, 20), new OffsetBitVector(25, 10));
    }

    private <T extends BitVectorBase> void testBitVectors(T v1, T v2) {
        v1.set(100);
        v1.set(101);
        v1.set(102);
        Assert.assertTrue((String)("v1.max() is " + v1.max()), (v1.max() == 102 ? 1 : 0) != 0);
        v2.set(200);
        v2.set(201);
        v2.set(202);
        Assert.assertTrue((String)("v2.max() is " + v2.max()), (v2.max() == 202 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)v1.intersectionEmpty(v2));
        Assert.assertTrue((boolean)v2.intersectionEmpty(v1));
        v1.or(v2);
        System.err.println("v1 = " + v1 + ", v2 = " + v2);
        Assert.assertFalse((String)("v1 = " + v1 + ", v2 = " + v2), (boolean)v1.intersectionEmpty(v2));
        Assert.assertFalse((String)("v1 = " + v1 + ", v2 = " + v2), (boolean)v2.intersectionEmpty(v1));
        Assert.assertTrue((String)("v1.max() is " + v1.max()), (v1.max() == 202 ? 1 : 0) != 0);
        boolean[] blArray = new boolean[7];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        boolean[] gets = blArray;
        int[] nArray = new int[7];
        nArray[1] = 100;
        nArray[2] = 101;
        nArray[3] = 102;
        nArray[4] = 200;
        nArray[5] = 201;
        nArray[6] = 202;
        int[] bits = nArray;
        int i = 0;
        int j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((v1.get(i) == gets[j] ? 1 : 0) != 0);
            i = v1.nextSetBit(i + 1);
            ++j;
        }
        v1.clearAll();
        v2.clearAll();
        v1.set(100);
        v1.set(101);
        v1.set(102);
        v1.set(103);
        v1.set(104);
        v1.set(105);
        Assert.assertTrue((String)("v1.max() is " + v1.max()), (v1.max() == 105 ? 1 : 0) != 0);
        v2.set(103);
        v2.set(104);
        v2.set(200);
        v2.set(201);
        Assert.assertTrue((String)("v2.max() is " + v2.max()), (v2.max() == 201 ? 1 : 0) != 0);
        v1.and(v2);
        Assert.assertTrue((String)("v1.max() is " + v1.max()), (v1.max() == 104 ? 1 : 0) != 0);
        boolean[] blArray2 = new boolean[3];
        blArray2[1] = true;
        blArray2[2] = true;
        gets = blArray2;
        int[] nArray2 = new int[3];
        nArray2[1] = 103;
        nArray2[2] = 104;
        bits = nArray2;
        i = 0;
        j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((v1.get(i) == gets[j] ? 1 : 0) != 0);
            i = v1.nextSetBit(i + 1);
            ++j;
        }
        v1.set(100);
        v1.set(101);
        v1.set(102);
        v1.set(105);
        Assert.assertTrue((String)("v1.max() is " + v1.max()), (v1.max() == 105 ? 1 : 0) != 0);
        boolean[] blArray3 = new boolean[7];
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        blArray3[5] = true;
        blArray3[6] = true;
        gets = blArray3;
        int[] nArray3 = new int[7];
        nArray3[1] = 100;
        nArray3[2] = 101;
        nArray3[3] = 102;
        nArray3[4] = 103;
        nArray3[5] = 104;
        nArray3[6] = 105;
        bits = nArray3;
        i = 0;
        j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((v1.get(i) == gets[j] ? 1 : 0) != 0);
            i = v1.nextSetBit(i + 1);
            ++j;
        }
        v2.clear(103);
        v2.clear(104);
        v1.andNot(v2);
        boolean[] blArray4 = new boolean[7];
        blArray4[1] = true;
        blArray4[2] = true;
        blArray4[3] = true;
        blArray4[4] = true;
        blArray4[5] = true;
        blArray4[6] = true;
        gets = blArray4;
        int[] nArray4 = new int[7];
        nArray4[1] = 100;
        nArray4[2] = 101;
        nArray4[3] = 102;
        nArray4[4] = 103;
        nArray4[5] = 104;
        nArray4[6] = 105;
        bits = nArray4;
        i = 0;
        j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((v1.get(i) == gets[j] ? 1 : 0) != 0);
            i = v1.nextSetBit(i + 1);
            ++j;
        }
        v2.set(101);
        v2.set(102);
        System.err.println("v1 = " + v1 + ", v2 = " + v2);
        v1.andNot(v2);
        boolean[] blArray5 = new boolean[5];
        blArray5[1] = true;
        blArray5[2] = true;
        blArray5[3] = true;
        blArray5[4] = true;
        gets = blArray5;
        int[] nArray5 = new int[5];
        nArray5[1] = 100;
        nArray5[2] = 103;
        nArray5[3] = 104;
        nArray5[4] = 105;
        bits = nArray5;
        i = 0;
        j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((v1.get(i) == gets[j] ? 1 : 0) != 0);
            i = v1.nextSetBit(i + 1);
            ++j;
        }
        v1.clearAll();
        v2.clearAll();
        v1.set(35);
        v1.set(101);
        v1.set(102);
        v1.set(103);
        v1.set(104);
        v1.set(105);
        v2.set(101);
        v2.set(102);
        v2.set(104);
        v2.set(206);
        System.err.println("v1 = " + v1 + ", v2 = " + v2);
        v1.xor(v2);
        boolean[] blArray6 = new boolean[5];
        blArray6[1] = true;
        blArray6[2] = true;
        blArray6[3] = true;
        blArray6[4] = true;
        gets = blArray6;
        int[] nArray6 = new int[5];
        nArray6[1] = 35;
        nArray6[2] = 103;
        nArray6[3] = 105;
        nArray6[4] = 206;
        bits = nArray6;
        i = 0;
        j = 0;
        while (i != -1) {
            Assert.assertTrue((i == bits[j] ? 1 : 0) != 0);
            Assert.assertTrue((v1.get(i) == gets[j] ? 1 : 0) != 0);
            i = v1.nextSetBit(i + 1);
            ++j;
        }
        v2.set(35);
        v2.set(103);
        v2.set(105);
        System.err.println("v1 = " + v1 + ", v2 = " + v2);
        Assert.assertTrue((boolean)v1.isSubset(v2));
        v2.clearAll();
        v2.set(111);
        v2.or(v1);
        Assert.assertTrue((boolean)v1.isSubset(v2));
        v2.and(v1);
        Assert.assertTrue((boolean)v1.sameBits(v2));
        v1.clearAll();
    }

    private static OffsetBitVector makeBigTestOffsetVector() {
        OffsetBitVector v1 = new OffsetBitVector(50000096, 1024);
        v1.set(50000101);
        v1.set(50000103);
        v1.set(50000112);
        v1.set(50000114);
        v1.set(50000116);
        v1.set(50000126);
        v1.set(50000128);
        v1.set(50000129);
        v1.set(50000135);
        v1.set(50000137);
        v1.set(50000143);
        v1.set(50000148);
        v1.set(50000151);
        v1.set(50000158);
        v1.set(50000163);
        v1.set(50000167);
        v1.set(50000170);
        v1.set(50000173);
        v1.set(50000180);
        v1.set(50000182);
        v1.set(50000185);
        v1.set(50000187);
        v1.set(50000190);
        v1.set(50000194);
        v1.set(50000199);
        v1.set(50000201);
        v1.set(50000204);
        v1.set(50000206);
        v1.set(50000209);
        v1.set(50000210);
        v1.set(50000218);
        v1.set(50000221);
        v1.set(50000223);
        v1.set(50000227);
        v1.set(50000232);
        v1.set(50000234);
        v1.set(50000243);
        v1.set(50000246);
        v1.set(50000250);
        v1.set(50000257);
        v1.set(50000263);
        v1.set(50000268);
        v1.set(50000273);
        v1.set(50000275);
        v1.set(50000278);
        v1.set(50000282);
        v1.set(50000285);
        v1.set(50000290);
        v1.set(50000293);
        v1.set(50000298);
        v1.set(50000300);
        v1.set(50000303);
        v1.set(50000306);
        v1.set(50000308);
        v1.set(50000310);
        v1.set(50000315);
        v1.set(50000325);
        v1.set(50000327);
        v1.set(50000335);
        v1.set(50000337);
        v1.set(50000342);
        v1.set(50000345);
        v1.set(50000349);
        v1.set(50000360);
        v1.set(50000362);
        v1.set(50000369);
        v1.set(50000374);
        v1.set(50000375);
        v1.set(50000378);
        v1.set(50000380);
        v1.set(50000383);
        v1.set(50000384);
        v1.set(50000388);
        v1.set(50000391);
        v1.set(50000400);
        v1.set(50000405);
        v1.set(50000409);
        v1.set(50000414);
        v1.set(50000417);
        v1.set(50000421);
        v1.set(0x2FAF22A);
        v1.set(0x2FAF22F);
        v1.set(50000435);
        v1.set(50000437);
        v1.set(50000439);
        v1.set(50000442);
        v1.set(50000446);
        v1.set(50000450);
        v1.set(50000455);
        v1.set(50000459);
        v1.set(50000460);
        v1.set(50000463);
        v1.set(50000470);
        v1.set(50000471);
        v1.set(50000480);
        v1.set(50000497);
        v1.set(50000498);
        v1.set(50000500);
        v1.set(50000505);
        v1.set(50000508);
        v1.set(50000511);
        v1.set(50000513);
        v1.set(50000520);
        v1.set(50000526);
        v1.set(50000529);
        v1.set(50000536);
        v1.set(50000539);
        v1.set(50000551);
        v1.set(50000555);
        v1.set(0x2FAF2AF);
        v1.set(50000563);
        v1.set(50000564);
        v1.set(50000566);
        v1.set(50000568);
        v1.set(50000570);
        v1.set(50000576);
        v1.set(50000587);
        v1.set(50000590);
        v1.set(50000594);
        v1.set(50000601);
        v1.set(50000605);
        v1.set(50000608);
        v1.set(50000610);
        v1.set(50000619);
        v1.set(50000628);
        v1.set(50000630);
        v1.set(0x2FAF2FA);
        v1.set(50000644);
        v1.set(50000647);
        v1.set(50000654);
        v1.set(50000658);
        v1.set(50000661);
        v1.set(50000663);
        v1.set(50000669);
        v1.set(50000671);
        v1.set(50000673);
        v1.set(50000676);
        v1.set(50000677);
        v1.set(50000680);
        v1.set(50000689);
        v1.set(50000692);
        v1.set(50000695);
        v1.set(50000705);
        v1.set(50000707);
        v1.set(50000708);
        v1.set(50000714);
        v1.set(50000716);
        v1.set(50000721);
        v1.set(50000727);
        v1.set(50000732);
        v1.set(50000736);
        v1.set(50000739);
        v1.set(50000741);
        v1.set(50000750);
        v1.set(50000753);
        v1.set(50000755);
        v1.set(50000765);
        v1.set(50000769);
        v1.set(50000773);
        v1.set(50000779);
        v1.set(50000782);
        v1.set(50000784);
        v1.set(50000787);
        v1.set(50000791);
        v1.set(50000792);
        v1.set(50000793);
        v1.set(50000795);
        v1.set(50000801);
        v1.set(50000806);
        v1.set(50000809);
        return v1;
    }

    @Test
    public void testSpecificBugsInOffsetBitVectors() {
        OffsetBitVector v1 = PrimitivesTest.makeBigTestOffsetVector();
        System.err.println(v1);
        OffsetBitVector v2 = new OffsetBitVector(50000128, 512);
        v2.set(50000137);
        v2.set(50000204);
        v2.set(50000278);
        v2.set(50000315);
        v2.set(50000362);
        v2.set(50000450);
        v2.set(50000455);
        v2.set(50000471);
        System.err.println(v2);
        v1.andNot(v2);
        System.err.println(v1);
        Assert.assertTrue((boolean)v1.intersectionEmpty(v2));
        v1 = PrimitivesTest.makeBigTestOffsetVector();
        v1.and(v2);
        System.err.println(v1);
        Assert.assertTrue((boolean)v1.sameBits(v2));
        Assert.assertTrue((boolean)v1.isSubset(v2));
        Assert.assertTrue((boolean)v2.isSubset(v1));
    }

    @Test
    public void testSpecificBugsInSemiSparseMutableIntSets() {
        SemiSparseMutableIntSet v1 = new SemiSparseMutableIntSet();
        v1.add(54);
        v1.add(58);
        v1.add(59);
        v1.add(64);
        v1.add(67);
        v1.add(73);
        v1.add(83);
        v1.add(105);
        v1.add(110);
        v1.add(126);
        v1.add(136);
        v1.add(143);
        v1.add(150);
        v1.add(155);
        v1.add(156);
        v1.add(162);
        v1.add(168);
        v1.add(183);
        v1.add(191);
        v1.add(265);
        v1.add(294);
        v1.add(324);
        v1.add(344);
        v1.add(397);
    }
}

