/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.basic;

import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.DFSAllPathsFinder;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class PathFinderTest {
    private static final String edges1 = "ABBCBDCECFDGDHEIFIGJHJJKIKKL";
    private static final String edges2 = "ABBCBDCECFDGDHEIFIGJHJJKIKKCKL";
    private static final String edges3 = "ABBHBCBDCECFDGDHEIFIGJHJJKIKKCKL";
    private static final String edges4 = "ABACADAEBABCBDBECACBCDCEDADBDCDEEAEBECED";

    private static Graph<String> createGraph(String edges) {
        SlowSparseNumberedGraph<String> g = SlowSparseNumberedGraph.make();
        int i = 0;
        while (i < edges.length()) {
            String to;
            String from = edges.substring(i, i + 1);
            if (!g.containsNode(from)) {
                g.addNode(from);
            }
            if (!g.containsNode(to = edges.substring(i + 1, i + 2))) {
                g.addNode(to);
            }
            g.addEdge(from, to);
            i += 2;
        }
        return g;
    }

    private static DFSAllPathsFinder<String> makeFinder(Graph<String> g, String start, final String end) {
        return new DFSAllPathsFinder<String>(g, start, new Filter<String>(){

            @Override
            public boolean accepts(String o) {
                return end.equals(o);
            }
        });
    }

    private static void checkPaths(DFSAllPathsFinder<String> paths, int expectedCount) {
        List path;
        int count = 0;
        while ((path = paths.find()) != null) {
            System.err.println(path);
            ++count;
        }
        Assert.assertEquals((int)expectedCount, (int)count);
    }

    @Test
    public void testPaths1() {
        Graph<String> g = PathFinderTest.createGraph(edges1);
        DFSAllPathsFinder<String> paths = PathFinderTest.makeFinder(g, "A", "L");
        PathFinderTest.checkPaths(paths, 4);
    }

    @Test
    public void testPaths2() {
        Graph<String> g = PathFinderTest.createGraph(edges2);
        DFSAllPathsFinder<String> paths = PathFinderTest.makeFinder(g, "A", "L");
        PathFinderTest.checkPaths(paths, 4);
    }

    @Test
    public void testPaths3() {
        Graph<String> g = PathFinderTest.createGraph(edges3);
        DFSAllPathsFinder<String> paths = PathFinderTest.makeFinder(g, "A", "L");
        PathFinderTest.checkPaths(paths, 5);
    }

    @Test
    public void testPaths4() {
        Graph<String> g = PathFinderTest.createGraph(edges4);
        DFSAllPathsFinder<String> paths = PathFinderTest.makeFinder(g, "A", "E");
        PathFinderTest.checkPaths(paths, 16);
    }
}

