/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.basic;

import com.ibm.wala.core.tests.util.WalaTestCase;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFilter;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.BitVectorUnionConstant;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.MutableMapping;
import org.junit.Assert;
import org.junit.Test;

public class GraphDataflowTest
extends WalaTestCase {
    public static final String nodeNames = "ABCDEFGH";
    protected static final String[] nodes = new String["ABCDEFGH".length()];

    private static BitVector zero() {
        BitVector b = new BitVector();
        b.set(0);
        return b;
    }

    private static BitVector one() {
        BitVector b = new BitVector();
        b.set(1);
        return b;
    }

    @Test
    public void testSolverNodeEdge() throws CancelException {
        Graph<String> G = GraphDataflowTest.buildGraph();
        String result = GraphDataflowTest.solveNodeEdge(G);
        System.err.println(result);
        if (!result.equals(GraphDataflowTest.expectedStringNodeEdge())) {
            System.err.println("Uh oh.");
            System.err.println(GraphDataflowTest.expectedStringNodeEdge());
        }
        Assert.assertEquals((Object)GraphDataflowTest.expectedStringNodeEdge(), (Object)result);
    }

    @Test
    public void testSolverNodeOnly() throws CancelException {
        Graph<String> G = GraphDataflowTest.buildGraph();
        String result = GraphDataflowTest.solveNodeOnly(G);
        System.err.println(result);
        Assert.assertEquals((Object)GraphDataflowTest.expectedStringNodeOnly(), (Object)result);
    }

    public static String expectedStringNodeOnly() {
        StringBuffer result = new StringBuffer("------\n");
        result.append("Node A(0) = { 0 }\n");
        result.append("Node B(1) = { 0 1 }\n");
        result.append("Node C(2) = { 0 1 2 }\n");
        result.append("Node D(3) = { 0 1 3 }\n");
        result.append("Node E(4) = { 0 1 2 3 4 }\n");
        result.append("Node F(5) = { 0 1 2 3 4 5 }\n");
        result.append("Node G(6) = { 6 }\n");
        result.append("Node H(7) = { 7 }\n");
        return result.toString();
    }

    public static String expectedStringNodeEdge() {
        StringBuffer result = new StringBuffer("------\n");
        result.append("Node A(0) = { 0 }\n");
        result.append("Node B(1) = { 0 1 }\n");
        result.append("Node C(2) = { 0 2 }\n");
        result.append("Node D(3) = { 1 3 }\n");
        result.append("Node E(4) = { 0 1 2 3 4 }\n");
        result.append("Node F(5) = { 0 1 2 3 4 5 }\n");
        result.append("Node G(6) = { 6 }\n");
        result.append("Node H(7) = { 7 }\n");
        return result.toString();
    }

    private static Graph<String> buildGraph() {
        SlowSparseNumberedGraph<String> G = SlowSparseNumberedGraph.make();
        int i = 0;
        while (i < nodeNames.length()) {
            String n = nodeNames.substring(i, i + 1);
            G.addNode(n);
            GraphDataflowTest.nodes[i] = n;
            ++i;
        }
        G.addEdge(nodes[0], nodes[1]);
        G.addEdge(nodes[1], nodes[2]);
        G.addEdge(nodes[1], nodes[3]);
        G.addEdge(nodes[2], nodes[4]);
        G.addEdge(nodes[3], nodes[4]);
        G.addEdge(nodes[4], nodes[5]);
        return G;
    }

    private static String solveNodeOnly(Graph<String> G) throws CancelException {
        final MutableMapping values = new MutableMapping(nodes);
        ITransferFunctionProvider<String, BitVectorVariable> functions = new ITransferFunctionProvider<String, BitVectorVariable>(){

            @Override
            public UnaryOperator<BitVectorVariable> getNodeTransferFunction(String node) {
                return new BitVectorUnionConstant(values.getMappedIndex(node));
            }

            @Override
            public boolean hasNodeTransferFunctions() {
                return true;
            }

            @Override
            public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(String from, String to) {
                Assertions.UNREACHABLE();
                return null;
            }

            @Override
            public boolean hasEdgeTransferFunctions() {
                return false;
            }

            @Override
            public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
                return BitVectorUnion.instance();
            }
        };
        BitVectorFramework F = new BitVectorFramework(G, functions, values);
        BitVectorSolver<String> s = new BitVectorSolver<String>(F);
        s.solve(null);
        return GraphDataflowTest.result2String(s);
    }

    private static String solveNodeEdge(Graph<String> G) throws CancelException {
        final MutableMapping values = new MutableMapping(nodes);
        ITransferFunctionProvider<String, BitVectorVariable> functions = new ITransferFunctionProvider<String, BitVectorVariable>(){

            @Override
            public UnaryOperator<BitVectorVariable> getNodeTransferFunction(String node) {
                return new BitVectorUnionConstant(values.getMappedIndex(node));
            }

            @Override
            public boolean hasNodeTransferFunctions() {
                return true;
            }

            @Override
            public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(String from, String to) {
                if (from == nodes[1] && to == nodes[3]) {
                    return new BitVectorFilter(GraphDataflowTest.zero());
                }
                if (from == nodes[1] && to == nodes[2]) {
                    return new BitVectorFilter(GraphDataflowTest.one());
                }
                return BitVectorIdentity.instance();
            }

            @Override
            public boolean hasEdgeTransferFunctions() {
                return true;
            }

            @Override
            public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
                return BitVectorUnion.instance();
            }
        };
        BitVectorFramework F = new BitVectorFramework(G, functions, values);
        BitVectorSolver<String> s = new BitVectorSolver<String>(F);
        s.solve(null);
        return GraphDataflowTest.result2String(s);
    }

    public static String result2String(BitVectorSolver<String> solver) {
        StringBuffer result = new StringBuffer("------\n");
        int i = 0;
        while (i < nodes.length) {
            String n = nodes[i];
            BitVectorVariable varI = (BitVectorVariable)solver.getOut(n);
            String s = varI.toString();
            result.append("Node " + n + "(" + i + ") = " + s + "\n");
            ++i;
        }
        return result.toString();
    }
}

