/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.core.tests.basic;

import com.ibm.wala.util.graph.INodeWithNumberedEdges;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.DelegatingNumberedGraph;
import com.ibm.wala.util.graph.traverse.FloydWarshall;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class FloydWarshallTest {
    private final NumberedGraph<Node> G = FloydWarshallTest.makeGraph();
    private final int[][] shortestPaths = new int[][]{{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE}, {Integer.MAX_VALUE, Integer.MAX_VALUE, 1, 2, 3, 3, 4, 4, 5}, {Integer.MAX_VALUE, Integer.MAX_VALUE, 4, 1, 2, 2, 3, 3, 4}, {Integer.MAX_VALUE, Integer.MAX_VALUE, 3, 4, 1, 1, 2, 2, 3}, {Integer.MAX_VALUE, Integer.MAX_VALUE, 2, 3, 2, 4, 1, 5, 2}, {Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 1, 2}, {Integer.MAX_VALUE, Integer.MAX_VALUE, 1, 2, 1, 3, 2, 4, 1}, {Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 1}, {Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE}};

    private static NumberedGraph<Node> makeGraph() {
        DelegatingNumberedGraph<Node> G = new DelegatingNumberedGraph<Node>();
        int i = 0;
        while (i <= 8) {
            G.addNode(new Node(i));
            ++i;
        }
        G.addEdge((Node)G.getNode(1), (Node)G.getNode(2));
        G.addEdge((Node)G.getNode(2), (Node)G.getNode(3));
        G.addEdge((Node)G.getNode(3), (Node)G.getNode(4));
        G.addEdge((Node)G.getNode(3), (Node)G.getNode(5));
        G.addEdge((Node)G.getNode(4), (Node)G.getNode(6));
        G.addEdge((Node)G.getNode(5), (Node)G.getNode(7));
        G.addEdge((Node)G.getNode(6), (Node)G.getNode(8));
        G.addEdge((Node)G.getNode(7), (Node)G.getNode(8));
        G.addEdge((Node)G.getNode(6), (Node)G.getNode(4));
        G.addEdge((Node)G.getNode(6), (Node)G.getNode(2));
        return G;
    }

    @Test
    public void TestPathLengths() {
        int[][] result = FloydWarshall.shortestPathLengths(this.G);
        Assert.assertTrue((result.length == this.shortestPaths.length ? 1 : 0) != 0);
        int i = 0;
        while (i < result.length) {
            Assert.assertTrue((result[i].length == this.shortestPaths[i].length ? 1 : 0) != 0);
            int j = 0;
            while (j < result[i].length) {
                Assert.assertTrue((result[i][j] == this.shortestPaths[i][j] ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void TestShortestPath() {
        FloydWarshall.GetPath<Node> result = FloydWarshall.allPairsShortestPath(this.G);
        Assert.assertEquals(result.getPath((Node)this.G.getNode(1), (Node)this.G.getNode(3)), Collections.singletonList((Node)this.G.getNode(2)));
        Assert.assertEquals(result.getPath((Node)this.G.getNode(5), (Node)this.G.getNode(8)), Collections.singletonList((Node)this.G.getNode(7)));
        Assert.assertEquals(result.getPath((Node)this.G.getNode(1), (Node)this.G.getNode(7)), Arrays.asList((Node)this.G.getNode(2), (Node)this.G.getNode(3), (Node)this.G.getNode(5)));
        Assert.assertEquals(result.getPath((Node)this.G.getNode(1), (Node)this.G.getNode(6)), Arrays.asList((Node)this.G.getNode(2), (Node)this.G.getNode(3), (Node)this.G.getNode(4)));
    }

    @Test
    public void TestShortestPaths() {
        FloydWarshall.GetPaths<Node> result = FloydWarshall.allPairsShortestPaths(this.G);
        HashSet<List<Node>> paths = new HashSet<List<Node>>();
        paths.add(Arrays.asList((Node)this.G.getNode(2), (Node)this.G.getNode(3), (Node)this.G.getNode(4), (Node)this.G.getNode(6)));
        paths.add(Arrays.asList((Node)this.G.getNode(2), (Node)this.G.getNode(3), (Node)this.G.getNode(5), (Node)this.G.getNode(7)));
        Assert.assertEquals(result.getPaths((Node)this.G.getNode(1), (Node)this.G.getNode(8)), paths);
    }

    public static class Node
    implements INodeWithNumberedEdges {
        private final int number;
        private final MutableIntSet preds = IntSetUtil.make();
        private final MutableIntSet succs = IntSetUtil.make();

        @Override
        public int getGraphNodeId() {
            return this.number;
        }

        public Node(int number) {
            this.number = number;
        }

        @Override
        public void setGraphNodeId(int number) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IntSet getSuccNumbers() {
            return this.succs;
        }

        @Override
        public IntSet getPredNumbers() {
            return this.preds;
        }

        @Override
        public void addSucc(int n) {
            this.succs.add(n);
        }

        @Override
        public void addPred(int n) {
            this.preds.add(n);
        }

        @Override
        public void removeAllIncidentEdges() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeIncomingEdges() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeOutgoingEdges() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "[" + this.number + "]";
        }
    }
}

