/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.client;

import com.ibm.wala.client.EngineStopwatch;
import com.ibm.wala.util.perf.StopwatchGC;

public abstract class AbstractEngineStopwatch
implements EngineStopwatch {
    protected final StopwatchGC[] stopwatch = new StopwatchGC[this.getNumberOfCategories()];

    protected abstract int getNumberOfCategories();

    protected abstract String[] getCategoryNames();

    protected AbstractEngineStopwatch() {
        int i = 0;
        while (i < this.getNumberOfCategories()) {
            this.stopwatch[i] = new StopwatchGC(this.getCategoryNames()[i]);
            ++i;
        }
    }

    public final String report() {
        StringBuffer result = new StringBuffer();
        long total = 0L;
        int i = 0;
        while (i < this.getNumberOfCategories()) {
            total += this.stopwatch[i].getElapsedMillis();
            result.append(String.valueOf(this.getCategoryNames()[i]) + ": " + this.stopwatch[i].getElapsedMillis() + "\n");
            ++i;
        }
        result.append("Total       : " + total + "\n");
        return result.toString();
    }

    public void start(byte category) {
        this.stopwatch[category].start();
    }

    public void stop(byte category) {
        this.stopwatch[category].stop();
    }

    public StopwatchGC getTimer(byte category) {
        return this.stopwatch[category];
    }
}

