/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.JVMClass;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.InnerClassesReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.RuntimeInvisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.RuntimeVisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.generics.ClassSignature;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.shrike.ShrikeClassReaderHandle;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShrikeClass
extends JVMClass<IClassLoader> {
    static final boolean DEBUG = false;
    private final ShrikeClassReaderHandle reader;

    public ShrikeClass(ShrikeClassReaderHandle reader, IClassLoader loader, IClassHierarchy cha) throws InvalidClassFileException {
        super(loader, cha);
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = reader;
        this.computeTypeReference();
        this.hashCode = 2161 * this.getReference().hashCode();
        this.computeSuperName();
        this.computeModifiers();
        this.computeInterfaceNames();
        this.computeFields();
    }

    private void computeFields() throws InvalidClassFileException {
        ClassReader cr = this.reader.get();
        int fieldCount = cr.getFieldCount();
        ArrayList<FieldImpl> instanceList = new ArrayList<FieldImpl>(fieldCount);
        ArrayList<FieldImpl> staticList = new ArrayList<FieldImpl>(fieldCount);
        try {
            int i = 0;
            while (i < fieldCount) {
                int accessFlags = cr.getFieldAccessFlags(i);
                Atom name = Atom.findOrCreateUnicodeAtom(cr.getFieldName(i));
                ImmutableByteArray b = ImmutableByteArray.make(cr.getFieldType(i));
                Collection<Annotation> annotations = null;
                annotations = this.getRuntimeInvisibleAnnotations(i);
                Collection<Annotation> collection = annotations = annotations.isEmpty() ? null : annotations;
                if ((accessFlags & 8) == 0) {
                    this.addFieldToList(instanceList, name, b, accessFlags, annotations);
                } else {
                    this.addFieldToList(staticList, name, b, accessFlags, annotations);
                }
                ++i;
            }
            this.instanceFields = new IField[instanceList.size()];
            this.populateFieldArrayFromList(instanceList, this.instanceFields);
            this.staticFields = new IField[staticList.size()];
            this.populateFieldArrayFromList(staticList, this.staticFields);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void computeModifiers() throws InvalidClassFileException {
        this.modifiers = this.reader.get().getAccessFlags();
    }

    private void computeSuperName() {
        try {
            String s = this.reader.get().getSuperName();
            if (s != null) {
                this.superName = ImmutableByteArray.make("L" + s);
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
    }

    private void computeInterfaceNames() {
        try {
            String[] s = this.reader.get().getInterfaceNames();
            this.interfaceNames = new ImmutableByteArray[s.length];
            int i = 0;
            while (i < this.interfaceNames.length) {
                this.interfaceNames[i] = ImmutableByteArray.make("L" + s[i]);
                ++i;
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
    }

    protected ShrikeCTMethod[] computeDeclaredMethods() throws InvalidClassFileException {
        int methodCount = this.reader.get().getMethodCount();
        ShrikeCTMethod[] result = new ShrikeCTMethod[methodCount];
        int i = 0;
        while (i < methodCount) {
            ShrikeCTMethod m;
            result[i] = m = new ShrikeCTMethod(this, i);
            ++i;
        }
        return result;
    }

    private void computeTypeReference() throws InvalidClassFileException {
        String className = "L" + this.reader.get().getName();
        ImmutableByteArray name = ImmutableByteArray.make(className);
        this.typeReference = TypeReference.findOrCreate(this.getClassLoader().getReference(), TypeName.findOrCreate(name));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShrikeClass) {
            return this.getReference().equals(((ShrikeClass)obj).getReference());
        }
        return false;
    }

    public ClassReader getReader() {
        try {
            return this.reader.get();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public void clearSoftCaches() {
        if (this.methodMap != null) {
            for (ShrikeCTMethod shrikeCTMethod : this.getDeclaredMethods()) {
                shrikeCTMethod.clearCaches();
            }
        }
        this.inheritCache = null;
        this.allInterfaces = null;
        this.reader.clear();
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(true);
    }

    public Collection<Annotation> getRuntimeVisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(false);
    }

    public Collection<Annotation> getAnnotations(boolean runtimeInvisible) throws InvalidClassFileException {
        AnnotationsReader r = this.getAnnotationsReader(runtimeInvisible);
        return Annotation.getAnnotationsFromReader(r, this.getClassLoader().getReference());
    }

    private AnnotationsReader getAnnotationsReader(boolean runtimeInvisable) throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        AnnotationsReader result = null;
        try {
            while (attrs.isValid()) {
                if (runtimeInvisable) {
                    if (attrs.getName().equals("RuntimeInvisibleAnnotations")) {
                        result = new RuntimeInvisibleAnnotationsReader(attrs);
                        break;
                    }
                } else if (attrs.getName().equals("RuntimeVisibleAnnotations")) {
                    result = new RuntimeVisibleAnnotationsReader(attrs);
                    break;
                }
                attrs.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private InnerClassesReader getInnerClassesReader() throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        InnerClassesReader result = null;
        try {
            while (attrs.isValid()) {
                if (attrs.getName().equals("InnerClasses")) {
                    result = new InnerClassesReader(attrs);
                    break;
                }
                attrs.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private RuntimeInvisibleAnnotationsReader getRuntimeInvisibleAnnotationsReader(int fieldIndex) throws InvalidClassFileException {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.reader.get().initFieldAttributeIterator(fieldIndex, iter);
        RuntimeInvisibleAnnotationsReader result = null;
        try {
            while (iter.isValid()) {
                if (iter.getName().toString().equals("RuntimeInvisibleAnnotations")) {
                    result = new RuntimeInvisibleAnnotationsReader(iter);
                    break;
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations(int fieldIndex) throws InvalidClassFileException {
        RuntimeInvisibleAnnotationsReader r = this.getRuntimeInvisibleAnnotationsReader(fieldIndex);
        return Annotation.getAnnotationsFromReader(r, this.getClassLoader().getReference());
    }

    private SignatureReader getSignatureReader() throws InvalidClassFileException {
        ClassReader r = this.reader.get();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        r.initClassAttributeIterator(attrs);
        SignatureReader result = null;
        try {
            while (attrs.isValid()) {
                if (attrs.getName().toString().equals("Signature")) {
                    result = new SignatureReader(attrs);
                    break;
                }
                attrs.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    public ClassSignature getClassSignature() throws InvalidClassFileException {
        SignatureReader r = this.getSignatureReader();
        if (r == null) {
            return null;
        }
        return ClassSignature.make(r.getSignature());
    }

    public ModuleEntry getModuleEntry() {
        return this.reader.getModuleEntry();
    }

    public boolean isInnerClass() throws InvalidClassFileException {
        InnerClassesReader r = this.getInnerClassesReader();
        if (r != null) {
            String[] stringArray = r.getInnerClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equals(this.getName().toString().substring(1))) {
                    String outer = r.getOuterClass(s);
                    return outer != null;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isStaticInnerClass() throws InvalidClassFileException {
        InnerClassesReader r = this.getInnerClassesReader();
        if (r != null) {
            String[] stringArray = r.getInnerClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String outer;
                String s = stringArray[n2];
                if (s.equals(this.getName().toString().substring(1)) && (outer = r.getOuterClass(s)) != null) {
                    int modifiers = r.getAccessFlags(s);
                    boolean result = (modifiers & 8) != 0;
                    return result;
                }
                ++n2;
            }
        }
        return false;
    }

    public TypeReference getOuterClass() throws InvalidClassFileException {
        if (!this.isInnerClass()) {
            return null;
        }
        InnerClassesReader r = this.getInnerClassesReader();
        String[] stringArray = r.getInnerClasses();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String outer;
            String s = stringArray[n2];
            if (s.equals(this.getName().toString().substring(1)) && (outer = r.getOuterClass(s)) != null) {
                return TypeReference.findOrCreate(this.getClassLoader().getReference(), "L" + outer);
            }
            ++n2;
        }
        return null;
    }
}

