/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.ShrikeBTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.IndirectionData;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.ExceptionsReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.RuntimeInvisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.RuntimeVisibleAnnotationsReader;
import com.ibm.wala.shrikeCT.SignatureReader;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.types.generics.MethodTypeSignature;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShrikeCTMethod
extends ShrikeBTMethod
implements IBytecodeMethod {
    private final int shrikeMethodIndex;
    private int modifiers = -1;
    private final IClassHierarchy cha;
    private static final IndirectionData NO_INDIRECTIONS = new IndirectionData(){
        private final int[] NOTHING = new int[0];

        public int[] indirectlyReadLocals(int instructionIndex) {
            return this.NOTHING;
        }

        public int[] indirectlyWrittenLocals(int instructionIndex) {
            return this.NOTHING;
        }
    };

    public ShrikeCTMethod(IClass klass, int index) {
        super(klass);
        if (klass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        this.shrikeMethodIndex = index;
        this.cha = klass.getClassHierarchy();
    }

    @Override
    public byte[] getBytecodes() {
        CodeReader code = this.getCodeReader();
        if (code == null) {
            return null;
        }
        return code.getBytecode();
    }

    @Override
    protected String getMethodName() throws InvalidClassFileException {
        ClassReader reader = this.getClassReader();
        return reader.getMethodName(this.shrikeMethodIndex);
    }

    @Override
    protected String getMethodSignature() throws InvalidClassFileException {
        ClassReader reader = this.getClassReader();
        return reader.getMethodType(this.shrikeMethodIndex);
    }

    @Override
    protected int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.getClassReader().getMethodAccessFlags(this.shrikeMethodIndex);
        }
        return this.modifiers;
    }

    @Override
    protected Decoder makeDecoder() {
        CodeReader reader = this.getCodeReader();
        if (reader == null) {
            return null;
        }
        CTDecoder d = new CTDecoder(reader);
        try {
            d.decode();
        }
        catch (Decoder.InvalidBytecodeException ex) {
            Assertions.UNREACHABLE();
        }
        return d;
    }

    @Override
    public int getMaxLocals() {
        CodeReader reader = this.getCodeReader();
        return reader.getMaxLocals();
    }

    @Override
    public int getMaxStackHeight() {
        CodeReader reader = this.getCodeReader();
        return reader.getMaxStack() + 2;
    }

    @Override
    public boolean hasExceptionHandler() {
        CodeReader reader = this.getCodeReader();
        if (reader == null) {
            return false;
        }
        int[] handlers = reader.getRawHandlers();
        return handlers != null && handlers.length > 0;
    }

    @Override
    protected String[] getDeclaredExceptionTypeNames() throws InvalidClassFileException {
        ExceptionsReader reader = this.getExceptionReader();
        if (reader == null) {
            return null;
        }
        return reader.getClasses();
    }

    @Override
    protected void processDebugInfo(ShrikeBTMethod.BytecodeInfo bcInfo) throws InvalidClassFileException {
        CodeReader cr = this.getCodeReader();
        bcInfo.lineNumberMap = LineNumberTableReader.makeBytecodeToSourceMap(cr);
        bcInfo.localVariableMap = LocalVariableTableReader.makeVarMap(cr);
    }

    @Override
    public String getLocalVariableName(int bcIndex, int localNumber) {
        int[][] map = null;
        try {
            map = this.getBCInfo().localVariableMap;
        }
        catch (InvalidClassFileException e1) {
            return null;
        }
        if (localNumber > this.getMaxLocals()) {
            throw new IllegalArgumentException("illegal local number: " + localNumber + ", method " + this.getName() + " uses at most " + this.getMaxLocals());
        }
        if (map == null) {
            return null;
        }
        int[] localPairs = map[bcIndex];
        int localIndex = localNumber * 2;
        if (localPairs == null || localIndex >= localPairs.length) {
            return null;
        }
        int nameIndex = localPairs[localIndex];
        if (nameIndex == 0) {
            return null;
        }
        try {
            return this.getClassReader().getCP().getCPUtf8(nameIndex);
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasLocalVariableTable() {
        try {
            ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
            this.getCodeReader().initAttributeIterator(iter);
            while (true) {
                if (!iter.isValid()) {
                    return false;
                }
                if (iter.getName().equals("LocalVariableTable")) {
                    return true;
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return false;
        }
    }

    private ClassReader getClassReader() {
        return ((ShrikeClass)this.getDeclaringClass()).getReader();
    }

    private CodeReader getCodeReader() {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, iter);
        CodeReader code = null;
        try {
            while (iter.isValid()) {
                if (iter.getName().equals("Code")) {
                    code = new CodeReader(iter);
                    break;
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return code;
    }

    private ExceptionsReader getExceptionReader() {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, iter);
        ExceptionsReader result = null;
        try {
            while (iter.isValid()) {
                if (iter.getName().equals("Exceptions")) {
                    result = new ExceptionsReader(iter);
                    break;
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private SignatureReader getSignatureReader() {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, iter);
        SignatureReader result = null;
        try {
            while (iter.isValid()) {
                if (iter.getName().equals("Signature")) {
                    result = new SignatureReader(iter);
                    break;
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private AnnotationsReader getAnnotationsReader(boolean runtimeInvisible) {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.getClassReader().initMethodAttributeIterator(this.shrikeMethodIndex, iter);
        AnnotationsReader result = null;
        try {
            while (iter.isValid()) {
                if (runtimeInvisible) {
                    if (iter.getName().equals("RuntimeInvisibleAnnotations")) {
                        result = new RuntimeInvisibleAnnotationsReader(iter);
                        break;
                    }
                } else if (iter.getName().equals("RuntimeVisibleAnnotations")) {
                    result = new RuntimeVisibleAnnotationsReader(iter);
                    break;
                }
                iter.advance();
            }
        }
        catch (InvalidClassFileException e) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private String computeGenericsSignature() throws InvalidClassFileException {
        SignatureReader reader = this.getSignatureReader();
        if (reader == null) {
            return null;
        }
        return reader.getSignature();
    }

    @Override
    public TypeReference getReturnType() {
        return this.getReference().getReturnType();
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    private String getGenericsSignature() throws InvalidClassFileException {
        return this.computeGenericsSignature();
    }

    public MethodTypeSignature getMethodTypeSignature() throws InvalidClassFileException {
        String sig = this.getGenericsSignature();
        return sig == null ? null : MethodTypeSignature.make(sig);
    }

    public Collection<Annotation> getRuntimeInvisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(true);
    }

    public Collection<Annotation> getRuntimeVisibleAnnotations() throws InvalidClassFileException {
        return this.getAnnotations(false);
    }

    public Collection<Annotation> getAnnotations(boolean runtimeInvisible) throws InvalidClassFileException {
        AnnotationsReader r = this.getAnnotationsReader(runtimeInvisible);
        return Annotation.getAnnotationsFromReader(r, this.getDeclaringClass().getClassLoader().getReference());
    }

    @Override
    public IndirectionData getIndirectionData() {
        return NO_INDIRECTIONS;
    }
}

