/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.LanguageImpl;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.shrike.Exceptions;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLanguage
extends LanguageImpl
implements BytecodeLanguage,
Constants {
    private static final Collection<TypeReference> arrayAccessExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangNullPointerException, TypeReference.JavaLangArrayIndexOutOfBoundsException));
    private static final Collection<TypeReference> aaStoreExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangNullPointerException, TypeReference.JavaLangArrayIndexOutOfBoundsException, TypeReference.JavaLangArrayStoreException));
    private static final Collection<TypeReference> newScalarExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangExceptionInInitializerError, TypeReference.JavaLangOutOfMemoryError));
    private static final Collection<TypeReference> newArrayExceptions = Collections.unmodifiableCollection(Arrays.asList(TypeReference.JavaLangOutOfMemoryError, TypeReference.JavaLangNegativeArraySizeException));
    private static final Collection<TypeReference> exceptionInInitializerError = Collections.singleton(TypeReference.JavaLangExceptionInInitializerError);
    private static final Collection<TypeReference> nullPointerException = Collections.singleton(TypeReference.JavaLangNullPointerException);
    private static final Collection<TypeReference> arithmeticException = Collections.singleton(TypeReference.JavaLangArithmeticException);
    private static final Collection<TypeReference> classCastException = Collections.singleton(TypeReference.JavaLangClassCastException);
    private static final Collection<TypeReference> classNotFoundException = Collections.singleton(TypeReference.JavaLangClassNotFoundException);
    private static final Collection<TypeReference> loadClassExceptions = Collections.singleton(TypeReference.JavaLangClassNotFoundException);
    private static final SSAInstructionFactory javaShrikeFactory = new JavaInstructionFactory();

    public JavaLanguage() {
        JavaPrimitiveType.init();
    }

    public static Collection<TypeReference> getAaStoreExceptions() {
        return aaStoreExceptions;
    }

    public static Collection<TypeReference> getArithmeticException() {
        return arithmeticException;
    }

    public static Collection<TypeReference> getArrayAccessExceptions() {
        return arrayAccessExceptions;
    }

    public static Collection<TypeReference> getClassCastException() {
        return classCastException;
    }

    public static Collection<TypeReference> getClassNotFoundException() {
        return classNotFoundException;
    }

    public static Collection<TypeReference> getNewArrayExceptions() {
        return newArrayExceptions;
    }

    public static Collection<TypeReference> getNewScalarExceptions() {
        return newScalarExceptions;
    }

    public static Collection<TypeReference> getNullPointerException() {
        return nullPointerException;
    }

    public static Collection<TypeReference> getExceptionInInitializerError() {
        return exceptionInInitializerError;
    }

    @Override
    public Atom getName() {
        return ClassLoaderReference.Java;
    }

    @Override
    public TypeReference getRootType() {
        return TypeReference.JavaLangObject;
    }

    @Override
    public TypeReference getThrowableType() {
        return TypeReference.JavaLangThrowable;
    }

    @Override
    public TypeReference getConstantType(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return TypeReference.Boolean;
        }
        if (o instanceof Long) {
            return TypeReference.Long;
        }
        if (o instanceof Double) {
            return TypeReference.Double;
        }
        if (o instanceof Float) {
            return TypeReference.Float;
        }
        if (o instanceof Number) {
            return TypeReference.Int;
        }
        if (o instanceof String) {
            return TypeReference.JavaLangString;
        }
        if (o instanceof ConstantInstruction.ClassToken || o instanceof TypeReference) {
            return TypeReference.JavaLangClass;
        }
        if (o instanceof IMethod) {
            IMethod m = (IMethod)o;
            return m.isInit() ? TypeReference.JavaLangReflectConstructor : TypeReference.JavaLangReflectMethod;
        }
        assert (false) : "unknown constant " + o + ": " + o.getClass();
        return null;
    }

    @Override
    public boolean isNullType(TypeReference type) {
        return type == null || type == TypeReference.Null;
    }

    @Override
    public TypeReference[] getArrayInterfaces() {
        return new TypeReference[]{TypeReference.JavaIoSerializable, TypeReference.JavaLangCloneable};
    }

    @Override
    public TypeName lookupPrimitiveType(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<TypeReference> inferInvokeExceptions(MethodReference target, IClassHierarchy cha) throws InvalidClassFileException {
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        ArrayList<TypeReference> set = new ArrayList<TypeReference>(cha.getJavaLangRuntimeExceptionTypes());
        set.addAll(cha.getJavaLangErrorTypes());
        IClass klass = cha.lookupClass(target.getDeclaringClass());
        if (klass == null) {
            Warnings.add(Exceptions.MethodResolutionFailure.moderate(target));
        }
        if (klass != null) {
            IMethod M = klass.getMethod(target.getSelector());
            if (M == null) {
                Warnings.add(Exceptions.MethodResolutionFailure.severe(target));
            } else {
                TypeReference[] exceptionTypes = M.getDeclaredExceptions();
                if (exceptionTypes != null) {
                    set.addAll(Arrays.asList(exceptionTypes));
                }
            }
        }
        return set;
    }

    @Override
    public Collection<TypeReference> getImplicitExceptionTypes(IInstruction pei) {
        if (pei == null) {
            throw new IllegalArgumentException("pei is null");
        }
        switch (((Instruction)pei).getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                return JavaLanguage.getArrayAccessExceptions();
            }
            case 83: {
                return JavaLanguage.getAaStoreExceptions();
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                return JavaLanguage.getNullPointerException();
            }
            case 108: 
            case 109: 
            case 112: 
            case 113: {
                return JavaLanguage.getArithmeticException();
            }
            case 187: {
                return newScalarExceptions;
            }
            case 188: 
            case 189: 
            case 197: {
                return newArrayExceptions;
            }
            case 190: {
                return JavaLanguage.getNullPointerException();
            }
            case 191: {
                return JavaLanguage.getNullPointerException();
            }
            case 192: {
                return JavaLanguage.getClassCastException();
            }
            case 194: 
            case 195: {
                return JavaLanguage.getNullPointerException();
            }
            case 19: {
                if (((ConstantInstruction)pei).getType().equals("Ljava/lang/Class;")) {
                    return JavaLanguage.getClassNotFoundException();
                }
                return null;
            }
            case 178: 
            case 179: {
                return JavaLanguage.getExceptionInInitializerError();
            }
        }
        return Collections.emptySet();
    }

    @Override
    public SSAInstructionFactory instructionFactory() {
        return javaShrikeFactory;
    }

    @Override
    public boolean isDoubleType(TypeReference type) {
        return type == TypeReference.Double;
    }

    @Override
    public boolean isFloatType(TypeReference type) {
        return type == TypeReference.Float;
    }

    @Override
    public boolean isIntType(TypeReference type) {
        return type == TypeReference.Int;
    }

    @Override
    public boolean isLongType(TypeReference type) {
        return type == TypeReference.Long;
    }

    @Override
    public boolean isVoidType(TypeReference type) {
        return type == TypeReference.Void;
    }

    @Override
    public boolean isMetadataType(TypeReference type) {
        return type == TypeReference.JavaLangClass;
    }

    @Override
    public boolean isStringType(TypeReference type) {
        return type == TypeReference.JavaLangString;
    }

    @Override
    public boolean isBooleanType(TypeReference type) {
        return type == TypeReference.Boolean;
    }

    @Override
    public boolean isCharType(TypeReference type) {
        return type == TypeReference.Char;
    }

    @Override
    public Object getMetadataToken(Object value) {
        if (value instanceof ConstantInstruction.ClassToken) {
            return ShrikeUtil.makeTypeReference(ClassLoaderReference.Primordial, ((ConstantInstruction.ClassToken)value).getTypeName());
        }
        assert (value instanceof TypeReference);
        return value;
    }

    @Override
    public TypeReference getPointerType(TypeReference pointee) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Java does not permit explicit pointers");
    }

    @Override
    public TypeReference getMetadataType() {
        return TypeReference.JavaLangClass;
    }

    @Override
    public TypeReference getStringType() {
        return TypeReference.JavaLangString;
    }

    @Override
    public PrimitiveType getPrimitive(TypeReference reference) {
        return JavaPrimitiveType.getPrimitive(reference);
    }

    public static class JavaInstructionFactory
    implements SSAInstructionFactory {
        public SSAArrayLengthInstruction ArrayLengthInstruction(int result, int arrayref) {
            return new SSAArrayLengthInstruction(result, arrayref){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAArrayLoadInstruction ArrayLoadInstruction(int result, int arrayref, int index, TypeReference declaredType) {
            return new SSAArrayLoadInstruction(result, arrayref, index, declaredType){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getArrayAccessExceptions();
                }
            };
        }

        public SSAArrayStoreInstruction ArrayStoreInstruction(int arrayref, int index, int value, TypeReference declaredType) {
            return new SSAArrayStoreInstruction(arrayref, index, value, declaredType){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (this.typeIsPrimitive()) {
                        return JavaLanguage.getArrayAccessExceptions();
                    }
                    return JavaLanguage.getAaStoreExceptions();
                }
            };
        }

        public SSABinaryOpInstruction BinaryOpInstruction(IBinaryOpInstruction.IOperator operator, boolean overflow, boolean unsigned, int result, int val1, int val2, boolean mayBeInteger) {
            assert (!overflow);
            assert (!unsigned);
            return new SSABinaryOpInstruction(operator, result, val1, val2, mayBeInteger){

                @Override
                public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
                    return insts.BinaryOpInstruction(this.getOperator(), false, false, defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], uses == null ? this.getUse(1) : uses[1], this.mayBeIntegerOp());
                }

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (this.isPEI()) {
                        return JavaLanguage.getArithmeticException();
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSACheckCastInstruction CheckCastInstruction(int result, int val, int[] typeValues, boolean isPEI) {
            throw new UnsupportedOperationException();
        }

        public SSACheckCastInstruction CheckCastInstruction(int result, int val, TypeReference[] types, boolean isPEI) {
            assert (types.length == 1);
            assert (isPEI);
            return new SSACheckCastInstruction(result, val, types, true){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getClassCastException();
                }
            };
        }

        public SSACheckCastInstruction CheckCastInstruction(int result, int val, int typeValue, boolean isPEI) {
            assert (isPEI);
            return this.CheckCastInstruction(result, val, new int[]{typeValue}, true);
        }

        public SSACheckCastInstruction CheckCastInstruction(int result, int val, TypeReference type, boolean isPEI) {
            assert (isPEI);
            return this.CheckCastInstruction(result, val, new TypeReference[]{type}, true);
        }

        public SSAComparisonInstruction ComparisonInstruction(IComparisonInstruction.Operator operator, int result, int val1, int val2) {
            return new SSAComparisonInstruction(operator, result, val1, val2);
        }

        public SSAConditionalBranchInstruction ConditionalBranchInstruction(IConditionalBranchInstruction.IOperator operator, TypeReference type, int val1, int val2) {
            return new SSAConditionalBranchInstruction(operator, type, val1, val2);
        }

        public SSAConversionInstruction ConversionInstruction(int result, int val, TypeReference fromType, TypeReference toType, boolean overflow) {
            assert (!overflow);
            return new SSAConversionInstruction(result, val, fromType, toType){

                public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
                    if (uses != null && uses.length == 0) {
                        throw new IllegalArgumentException("(uses != null) and (uses.length == 0)");
                    }
                    return insts.ConversionInstruction(defs == null || defs.length == 0 ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0], this.getFromType(), this.getToType(), false);
                }
            };
        }

        public SSAGetCaughtExceptionInstruction GetCaughtExceptionInstruction(int bbNumber, int exceptionValueNumber) {
            return new SSAGetCaughtExceptionInstruction(bbNumber, exceptionValueNumber);
        }

        public SSAGetInstruction GetInstruction(int result, FieldReference field) {
            return new SSAGetInstruction(result, field){};
        }

        public SSAGetInstruction GetInstruction(int result, int ref, FieldReference field) {
            return new SSAGetInstruction(result, ref, field){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAGotoInstruction GotoInstruction() {
            return new SSAGotoInstruction();
        }

        public SSAInstanceofInstruction InstanceofInstruction(int result, int ref, TypeReference checkedType) {
            return new SSAInstanceofInstruction(result, ref, checkedType);
        }

        public SSAInvokeInstruction InvokeInstruction(int result, int[] params, int exception, CallSiteReference site) {
            return new SSAInvokeInstruction(result, params, exception, site){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (!this.isStatic()) {
                        return JavaLanguage.getNullPointerException();
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSAInvokeInstruction InvokeInstruction(int[] params, int exception, CallSiteReference site) {
            return new SSAInvokeInstruction(params, exception, site){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (!this.isStatic()) {
                        return JavaLanguage.getNullPointerException();
                    }
                    return Collections.emptySet();
                }
            };
        }

        public SSAMonitorInstruction MonitorInstruction(int ref, boolean isEnter) {
            return new SSAMonitorInstruction(ref, isEnter){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSANewInstruction NewInstruction(int result, NewSiteReference site) {
            return new SSANewInstruction(result, site){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    if (this.getNewSite().getDeclaredType().isArrayType()) {
                        return JavaLanguage.getNewArrayExceptions();
                    }
                    return JavaLanguage.getNewScalarExceptions();
                }
            };
        }

        public SSAPhiInstruction PhiInstruction(int result, int[] params) throws IllegalArgumentException {
            return new SSAPhiInstruction(result, params){};
        }

        public SSAPutInstruction PutInstruction(int ref, int value, FieldReference field) {
            return new SSAPutInstruction(ref, value, field){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAPutInstruction PutInstruction(int value, FieldReference field) {
            return new SSAPutInstruction(value, field){};
        }

        public SSAReturnInstruction ReturnInstruction() {
            return new SSAReturnInstruction();
        }

        public SSAReturnInstruction ReturnInstruction(int result, boolean isPrimitive) {
            return new SSAReturnInstruction(result, isPrimitive);
        }

        public SSASwitchInstruction SwitchInstruction(int val, int defaultLabel, int[] casesAndLabels) {
            return new SSASwitchInstruction(val, defaultLabel, casesAndLabels);
        }

        public SSAThrowInstruction ThrowInstruction(int exception) {
            return new SSAThrowInstruction(exception){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNullPointerException();
                }
            };
        }

        public SSAUnaryOpInstruction UnaryOpInstruction(IUnaryOpInstruction.IOperator operator, int result, int val) {
            return new SSAUnaryOpInstruction(operator, result, val);
        }

        public SSALoadMetadataInstruction LoadMetadataInstruction(int lval, TypeReference entityType, Object token) {
            return new SSALoadMetadataInstruction(lval, entityType, token){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return loadClassExceptions;
                }
            };
        }

        public SSANewInstruction NewInstruction(int result, NewSiteReference site, int[] params) {
            return new SSANewInstruction(result, site, params){

                @Override
                public Collection<TypeReference> getExceptionTypes() {
                    return JavaLanguage.getNewArrayExceptions();
                }
            };
        }

        public SSAPiInstruction PiInstruction(int result, int val, int piBlock, int successorBlock, SSAInstruction cause) {
            return new SSAPiInstruction(result, val, piBlock, successorBlock, cause);
        }

        public SSAAddressOfInstruction AddressOfInstruction(int lval, int local, TypeReference pointeeType) {
            throw new UnsupportedOperationException();
        }

        public SSAAddressOfInstruction AddressOfInstruction(int lval, int local, int indexVal, TypeReference pointeeType) {
            throw new UnsupportedOperationException();
        }

        public SSAAddressOfInstruction AddressOfInstruction(int lval, int local, FieldReference field, TypeReference pointeeType) {
            throw new UnsupportedOperationException();
        }

        public SSALoadIndirectInstruction LoadIndirectInstruction(int lval, TypeReference t, int addressVal) {
            throw new UnsupportedOperationException();
        }

        public SSAStoreIndirectInstruction StoreIndirectInstruction(int addressVal, int rval, TypeReference pointeeType) {
            throw new UnsupportedOperationException();
        }
    }
}

