/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileModule
implements Module,
ModuleEntry {
    private final File file;

    public FileModule(File f) throws IllegalArgumentException {
        if (f == null) {
            throw new IllegalArgumentException("f is null");
        }
        this.file = f;
        if (!f.exists()) {
            throw new IllegalArgumentException("bad file " + f.getAbsolutePath());
        }
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        return new NonNullSingletonIterator<ModuleEntry>(this);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(this.getClass())) {
            FileModule other = (FileModule)o;
            return this.getName().equals(other.getName());
        }
        return false;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream getInputStream() {
        try {
            if (!this.file.exists()) {
                System.err.println("PANIC: File does not exist! " + this.file);
            }
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE("could not read " + this.file);
            return null;
        }
    }

    @Override
    public boolean isModuleFile() {
        return false;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Module asModule() throws UnimplementedError {
        Assertions.UNREACHABLE("implement me");
        return null;
    }
}

