/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryTreeModule
implements Module {
    protected final File root;

    DirectoryTreeModule(File root) throws IllegalArgumentException {
        this.root = root;
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        if (!root.isDirectory()) {
            throw new IllegalArgumentException("root is not a directory " + root);
        }
    }

    protected abstract FileModule makeFile(File var1);

    protected abstract boolean includeFile(File var1);

    private Set<ModuleEntry> getEntriesRecursive(File dir) {
        HashSet<ModuleEntry> result = HashSetFactory.make();
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                FileModule fileModule;
                if (files[i].isDirectory()) {
                    result.addAll(this.getEntriesRecursive(files[i]));
                } else if (this.includeFile(files[i]) && (fileModule = this.makeFile(files[i])) != null) {
                    result.add(fileModule);
                }
                ++i;
            }
        } else {
            System.err.println("Warning: failed to retrieve files in " + dir);
        }
        return result;
    }

    @Override
    public Iterator<ModuleEntry> getEntries() {
        return this.getEntriesRecursive(this.root).iterator();
    }

    public String getPath() {
        return this.root.getAbsolutePath();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.getPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryTreeModule other = (DirectoryTreeModule)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }
}

