/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.ClassHierarchyWarning;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.BimodalMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.SmallMap;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BytecodeClass<T extends IClassLoader>
implements IClass {
    protected ImmutableByteArray superName;
    protected ImmutableByteArray[] interfaceNames;
    protected final T loader;
    protected final IClassHierarchy cha;
    protected Map<Selector, IMethod> methodMap;
    protected Map<Selector, IMethod> inheritCache;
    protected TypeReference typeReference;
    protected IClass superClass;
    protected boolean superclassComputed = false;
    protected Collection<IClass> allInterfaces = null;
    protected IField[] instanceFields;
    protected IField[] staticFields;
    protected int hashCode;
    private final HashMap<Atom, IField> fieldMap = HashMapFactory.make(5);

    protected BytecodeClass(T loader, IClassHierarchy cha) {
        this.loader = loader;
        this.cha = cha;
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    protected abstract IMethod[] computeDeclaredMethods() throws InvalidClassFileException;

    @Override
    public TypeReference getReference() {
        return this.typeReference;
    }

    @Override
    public String getSourceFileName() {
        return this.loader.getSourceFileName(this);
    }

    @Override
    public InputStream getSource() {
        return this.loader.getSource(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getReference().toString();
    }

    @Override
    public boolean isArrayClass() {
        return false;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    public TypeName getName() {
        return this.getReference().getName();
    }

    @Override
    public boolean isReferenceType() {
        return this.getReference().isReferenceType();
    }

    @Override
    public IField getField(Atom name) {
        IField f;
        if (this.fieldMap.containsKey(name)) {
            return this.fieldMap.get(name);
        }
        List<IField> fields = this.findDeclaredField(name);
        if (!fields.isEmpty()) {
            if (fields.size() == 1) {
                IField f2 = fields.iterator().next();
                this.fieldMap.put(name, f2);
                return f2;
            }
            throw new IllegalStateException("multiple fields with name " + name);
        }
        this.superClass = this.getSuperclass();
        if (this.superClass != null && (f = this.superClass.getField(name)) != null) {
            this.fieldMap.put(name, f);
            return f;
        }
        for (IClass i : this.getAllImplementedInterfaces()) {
            IField f3 = i.getField(name);
            if (f3 == null) continue;
            this.fieldMap.put(name, f3);
            return f3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IField getField(Atom name, TypeName type) {
        try {
            field = this.getField(name);
            if (field != null && field.getFieldTypeReference().getName().equals(type)) {
                return field;
            }
            return null;
        }
        catch (IllegalStateException e) {
            if (!BytecodeClass.$assertionsDisabled && !e.getMessage().startsWith("multiple fields with")) {
                throw new AssertionError();
            }
            fields = this.findDeclaredField(name);
            ** for (f : fields)
        }
lbl-1000:
        // 1 sources

        {
            if (!f.getFieldTypeReference().getName().equals(type)) continue;
            return f;
        }
lbl13:
        // 1 sources

        if (this.getSuperclass() != null && (f = this.superClass.getField(name, type)) != null) {
            return f;
        }
        for (IClass i : this.getAllImplementedInterfaces()) {
            f = i.getField(name, type);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private void computeSuperclass() {
        this.superclassComputed = true;
        if (this.superName == null) {
            if (!this.getReference().equals(this.loader.getLanguage().getRootType())) {
                this.superClass = this.loader.lookupClass(this.loader.getLanguage().getRootType().getName());
            }
            return;
        }
        this.superClass = this.loader.lookupClass(TypeName.findOrCreate(this.superName));
    }

    @Override
    public IClass getSuperclass() {
        if (!this.superclassComputed) {
            this.computeSuperclass();
        }
        if (this.superClass == null && !this.getReference().equals(TypeReference.JavaLangObject)) {
            throw new IllegalStateException("No superclass found for " + this + " Superclass name " + this.superName);
        }
        return this.superClass;
    }

    @Override
    public Collection<IField> getAllFields() {
        LinkedList<IField> result = new LinkedList<IField>();
        result.addAll(this.getAllInstanceFields());
        result.addAll(this.getAllStaticFields());
        return result;
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        if (this.allInterfaces != null) {
            return this.allInterfaces;
        }
        Collection<IClass> C = this.computeAllInterfacesAsCollection();
        this.allInterfaces = Collections.unmodifiableCollection(C);
        return this.allInterfaces;
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() {
        return Collections.unmodifiableList(Arrays.asList(this.instanceFields));
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        return Collections.unmodifiableList(Arrays.asList(this.staticFields));
    }

    @Override
    public Collection<? extends IClass> getDirectInterfaces() {
        return this.array2IClassSet(this.interfaceNames);
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        LinkedList<IField> result = new LinkedList<IField>(this.getDeclaredInstanceFields());
        IClass s = this.getSuperclass();
        while (s != null) {
            result.addAll(s.getDeclaredInstanceFields());
            s = s.getSuperclass();
        }
        return result;
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        LinkedList<IField> result = new LinkedList<IField>(this.getDeclaredStaticFields());
        IClass s = this.getSuperclass();
        while (s != null) {
            result.addAll(s.getDeclaredStaticFields());
            s = s.getSuperclass();
        }
        return result;
    }

    @Override
    public Collection<IMethod> getAllMethods() {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        Iterator<IMethod> declaredMethods = this.getDeclaredMethods().iterator();
        while (declaredMethods.hasNext()) {
            result.add(declaredMethods.next());
        }
        if (this.isInterface()) {
            for (IClass i : this.getDirectInterfaces()) {
                result.addAll(i.getAllMethods());
            }
        }
        IClass s = this.getSuperclass();
        while (s != null) {
            Iterator<IMethod> superDeclaredMethods = s.getDeclaredMethods().iterator();
            while (superDeclaredMethods.hasNext()) {
                result.add(superDeclaredMethods.next());
            }
            s = s.getSuperclass();
        }
        return result;
    }

    @Override
    public Collection<IMethod> getDeclaredMethods() {
        if (this.methodMap == null) {
            try {
                this.computeMethodMap();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
        return Collections.unmodifiableCollection(this.methodMap.values());
    }

    @Override
    public IMethod getMethod(Selector selector) {
        IMethod inherit;
        IClass superclass;
        IMethod result;
        if (this.methodMap == null) {
            try {
                this.computeMethodMap();
            }
            catch (InvalidClassFileException e1) {
                e1.printStackTrace();
                Assertions.UNREACHABLE();
            }
        }
        if ((result = this.methodMap.get(selector)) != null) {
            return result;
        }
        if (this.inheritCache != null && (result = this.inheritCache.get(selector)) != null) {
            return result;
        }
        if (!selector.equals(MethodReference.clinitSelector) && !selector.equals(MethodReference.initSelector) && (superclass = this.getSuperclass()) != null && (inherit = superclass.getMethod(selector)) != null) {
            if (this.inheritCache == null) {
                this.inheritCache = new BimodalMap<Selector, IMethod>(5);
            }
            this.inheritCache.put(selector, inherit);
            return inherit;
        }
        if (this.isInterface() || this.isAbstract()) {
            for (IClass k : this.getAllImplementedInterfaces()) {
                result = k.getMethod(selector);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected void populateFieldArrayFromList(List<FieldImpl> L, IField[] A2) {
        Iterator<FieldImpl> it = L.iterator();
        int i = 0;
        while (i < A2.length) {
            A2[i] = it.next();
            ++i;
        }
    }

    protected Collection<IClass> computeAllInterfacesAsCollection() {
        Collection<IClass> c = this.getDirectInterfaces();
        HashSet<IClass> result = HashSetFactory.make();
        for (IClass klass : c) {
            if (klass.isInterface()) {
                result.add(klass);
                continue;
            }
            Warnings.add(ClassHierarchyWarning.create("expected an interface " + klass));
        }
        HashSet<IClass> last = null;
        do {
            last = HashSetFactory.make(result);
            for (IClass i : last) {
                result.addAll(i.getDirectInterfaces());
            }
        } while (last.size() < result.size());
        IClass sup = null;
        sup = this.getSuperclass();
        if (sup != null) {
            result.addAll(sup.getAllImplementedInterfaces());
        }
        return result;
    }

    private Collection<IClass> array2IClassSet(ImmutableByteArray[] interfaces) {
        ArrayList<IClass> result = new ArrayList<IClass>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            ImmutableByteArray name = interfaces[i];
            IClass klass = null;
            klass = this.loader.lookupClass(TypeName.findOrCreate(name));
            if (klass == null) {
                Warnings.add(ClassNotFoundWarning.create(name));
            } else {
                result.add(klass);
            }
            ++i;
        }
        return result;
    }

    protected List<IField> findDeclaredField(Atom name) {
        int i;
        ArrayList<IField> result = new ArrayList<IField>(1);
        if (this.instanceFields != null) {
            i = 0;
            while (i < this.instanceFields.length) {
                if (this.instanceFields[i].getName() == name) {
                    result.add(this.instanceFields[i]);
                }
                ++i;
            }
        }
        if (this.staticFields != null) {
            i = 0;
            while (i < this.staticFields.length) {
                if (this.staticFields[i].getName() == name) {
                    result.add(this.staticFields[i]);
                }
                ++i;
            }
        }
        return result;
    }

    protected void addFieldToList(List<FieldImpl> L, Atom name, ImmutableByteArray fieldType, int accessFlags, Collection<Annotation> annotations) {
        TypeName T = null;
        T = fieldType.get(fieldType.length() - 1) == 59 ? TypeName.findOrCreate(fieldType, 0, fieldType.length() - 1) : TypeName.findOrCreate(fieldType);
        TypeReference type = TypeReference.findOrCreate(this.getClassLoader().getReference(), T);
        FieldReference fr = FieldReference.findOrCreate(this.getReference(), name, type);
        FieldImpl f = new FieldImpl(this, fr, accessFlags, annotations);
        L.add(f);
    }

    protected void computeMethodMap() throws InvalidClassFileException {
        if (this.methodMap == null) {
            IMethod[] methods = this.computeDeclaredMethods();
            this.methodMap = methods.length > 5 ? HashMapFactory.make(methods.length) : new SmallMap<Selector, IMethod>();
            int i = 0;
            while (i < methods.length) {
                IMethod m = methods[i];
                this.methodMap.put(m.getReference().getSelector(), m);
                ++i;
            }
        }
    }

    private static class ClassNotFoundWarning
    extends Warning {
        final ImmutableByteArray className;

        ClassNotFoundWarning(ImmutableByteArray className) {
            super((byte)2);
            this.className = className;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.className;
        }

        public static ClassNotFoundWarning create(ImmutableByteArray className) {
            return new ClassNotFoundWarning(className);
        }
    }
}

