/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static SSAInstruction getLastInstruction(ControlFlowGraph cfg, IBasicBlock b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (cfg == null) {
            throw new IllegalArgumentException("G is null");
        }
        return (SSAInstruction)cfg.getInstructions()[b.getLastInstructionIndex()];
    }

    public static boolean endsWithConditionalBranch(ControlFlowGraph G, IBasicBlock b) {
        return Util.getLastInstruction(G, b) instanceof SSAConditionalBranchInstruction;
    }

    public static boolean endsWithSwitch(ControlFlowGraph G, IBasicBlock b) {
        return Util.getLastInstruction(G, b) instanceof SSASwitchInstruction;
    }

    public static <I, T extends IBasicBlock<I>> T getFallThruBlock(ControlFlowGraph<I, T> G, T b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        return G.getBlockForInstruction(b.getLastInstructionIndex() + 1);
    }

    public static <I, T extends IBasicBlock<I>> T getNotTakenSuccessor(ControlFlowGraph<I, T> G, T b) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!Util.endsWithConditionalBranch(G, b)) {
            throw new IllegalArgumentException(String.valueOf(b.toString()) + " does not end with a conditional branch");
        }
        return Util.getFallThruBlock(G, b);
    }

    public static <I, T extends IBasicBlock<I>> T getTakenSuccessor(ControlFlowGraph<I, T> G, T b) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (!Util.endsWithConditionalBranch(G, b)) {
            throw new IllegalArgumentException(String.valueOf(b.toString()) + " does not end with a conditional branch");
        }
        T fs = Util.getNotTakenSuccessor(G, b);
        Iterator<T> ss = G.getSuccNodes(b);
        while (ss.hasNext()) {
            T s = ss.next();
            if (s == fs) continue;
            return s;
        }
        return fs;
    }

    public static <I, T extends IBasicBlock<I>> T resolveSwitch(ControlFlowGraph<I, T> G, T b, int c) {
        assert (Util.endsWithSwitch(G, b));
        SSASwitchInstruction s = (SSASwitchInstruction)Util.getLastInstruction(G, b);
        int[] casesAndLabels = s.getCasesAndLabels();
        int i = 0;
        while (i < casesAndLabels.length) {
            if (casesAndLabels[i] == c) {
                return G.getBlockForInstruction(casesAndLabels[i + 1]);
            }
            i += 2;
        }
        return G.getBlockForInstruction(s.getDefault());
    }

    public static <I, T extends IBasicBlock<I>> boolean isSwitchDefault(ControlFlowGraph<I, T> G, T b, T s) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        assert (Util.endsWithSwitch(G, b));
        SSASwitchInstruction sw = (SSASwitchInstruction)Util.getLastInstruction(G, b);
        assert (G.getBlockForInstruction(sw.getDefault()) != null);
        return G.getBlockForInstruction(sw.getDefault()).equals(s);
    }

    public static <I, T extends IBasicBlock<I>> int getSwitchLabel(ControlFlowGraph<I, T> G, T b, T s) {
        assert (Util.endsWithSwitch(G, b));
        SSASwitchInstruction sw = (SSASwitchInstruction)Util.getLastInstruction(G, b);
        int[] casesAndLabels = sw.getCasesAndLabels();
        int i = 0;
        while (i < casesAndLabels.length) {
            if (G.getBlockForInstruction(casesAndLabels[i + 1]).equals(s)) {
                return casesAndLabels[i];
            }
            i += 2;
        }
        Assertions.UNREACHABLE();
        return -1;
    }

    public static <I, T extends IBasicBlock<I>> T resolveBranch(ControlFlowGraph<I, T> G, T bb, int c1, int c2) {
        SSAConditionalBranchInstruction c = (SSAConditionalBranchInstruction)Util.getLastInstruction(G, bb);
        switch ((IConditionalBranchInstruction.Operator)c.getOperator()) {
            case EQ: {
                if (c1 == c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case NE: {
                if (c1 != c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case LT: {
                if (c1 < c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case GE: {
                if (c1 >= c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case GT: {
                if (c1 > c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
            case LE: {
                if (c1 <= c2) {
                    return Util.getTakenSuccessor(G, bb);
                }
                return Util.getNotTakenSuccessor(G, bb);
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static <I, T extends IBasicBlock<I>> int whichPred(ControlFlowGraph<I, T> cfg, T a, T b) {
        if (cfg == null) {
            throw new IllegalArgumentException("cfg is null");
        }
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        int i = 0;
        Iterator<T> it = cfg.getPredNodes(b);
        while (it.hasNext()) {
            if (it.next().equals(a)) {
                return i;
            }
            ++i;
        }
        Assertions.UNREACHABLE("Invalid: a must be a predecessor of b! " + a + " " + b);
        return -1;
    }
}

