/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg;

import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFGSanitizer {
    public static Graph<ISSABasicBlock> sanitize(IR ir, IClassHierarchy cha) throws IllegalArgumentException, WalaException {
        if (ir == null) {
            throw new IllegalArgumentException("ir cannot be null");
        }
        SSACFG cfg = ir.getControlFlowGraph();
        SlowSparseNumberedGraph<ISSABasicBlock> g = SlowSparseNumberedGraph.make();
        Iterator it = cfg.iterator();
        while (it.hasNext()) {
            g.addNode((ISSABasicBlock)it.next());
        }
        for (ISSABasicBlock b : cfg) {
            Iterator<ISSABasicBlock> it2 = cfg.getSuccNodes(b);
            while (it2.hasNext()) {
                ISSABasicBlock b2 = it2.next();
                if (b2.isExitBlock()) continue;
                g.addEdge(b, b2);
            }
        }
        ISSABasicBlock exit = (ISSABasicBlock)cfg.exit();
        Iterator<ISSABasicBlock> it2 = cfg.getPredNodes(exit);
        while (it2.hasNext()) {
            ISSABasicBlock b = it2.next();
            SSAInstruction s = ir.getInstructions()[b.getLastInstructionIndex()];
            if (s == null) continue;
            if (s instanceof SSAReturnInstruction || s instanceof SSAThrowInstruction || cfg.getSuccNodeCount(b) == 1) {
                g.addEdge(b, exit);
                continue;
            }
            TypeReference[] exceptions = null;
            try {
                exceptions = CFGSanitizer.computeExceptions(cha, ir, s);
            }
            catch (InvalidClassFileException e1) {
                e1.printStackTrace();
                Assertions.UNREACHABLE();
            }
            Iterator<ISSABasicBlock> it22 = cfg.getSuccNodes(b);
            while (it22.hasNext()) {
                IBasicBlock c = it22.next();
                if (!c.isCatchBlock()) continue;
                SSACFG.ExceptionHandlerBasicBlock cb = (SSACFG.ExceptionHandlerBasicBlock)c;
                Iterator<TypeReference> it3 = cb.getCaughtExceptionTypes();
                while (it3.hasNext()) {
                    TypeReference ex = it3.next();
                    IClass exClass = cha.lookupClass(ex);
                    if (exClass == null) {
                        throw new WalaException("failed to find " + ex);
                    }
                    int i = 0;
                    while (i < exceptions.length) {
                        if (exceptions[i] != null) {
                            IClass exi = cha.lookupClass(exceptions[i]);
                            if (exi == null) {
                                throw new WalaException("failed to find " + exceptions[i]);
                            }
                            if (cha.isSubclassOf(exi, exClass)) {
                                exceptions[i] = null;
                            }
                        }
                        ++i;
                    }
                }
            }
            TypeReference[] declared = null;
            try {
                declared = ir.getMethod().getDeclaredExceptions();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            if (declared == null || exceptions == null) continue;
            int i = 0;
            while (i < exceptions.length) {
                boolean isDeclared = false;
                if (exceptions[i] != null) {
                    IClass exi = cha.lookupClass(exceptions[i]);
                    if (exi == null) {
                        throw new WalaException("failed to find " + exceptions[i]);
                    }
                    int j = 0;
                    while (j < declared.length) {
                        IClass dc = cha.lookupClass(declared[j]);
                        if (dc == null) {
                            throw new WalaException("failed to find " + declared[j]);
                        }
                        if (cha.isSubclassOf(exi, dc)) {
                            isDeclared = true;
                            break;
                        }
                        ++j;
                    }
                    if (isDeclared) {
                        g.addEdge(b, exit);
                    }
                }
                ++i;
            }
        }
        return g;
    }

    private static TypeReference[] computeExceptions(IClassHierarchy cha, IR ir, SSAInstruction s) throws InvalidClassFileException {
        Collection<TypeReference> c = null;
        Language l = ir.getMethod().getDeclaringClass().getClassLoader().getLanguage();
        if (s instanceof SSAInvokeInstruction) {
            SSAInvokeInstruction call = (SSAInvokeInstruction)s;
            c = l.inferInvokeExceptions(call.getDeclaredTarget(), cha);
        } else {
            c = s.getExceptionTypes();
        }
        if (c == null) {
            return null;
        }
        TypeReference[] exceptions = new TypeReference[c.size()];
        Iterator<TypeReference> it = c.iterator();
        int i = 0;
        while (i < exceptions.length) {
            exceptions[i] = it.next();
            ++i;
        }
        return exceptions;
    }
}

