/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.IllegalArgumentExceptionContext;
import com.ibm.wala.analysis.reflection.ReflectiveInvocationInterpreter;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;

class ReflectiveInvocationSelector
implements ContextSelector {
    private static final IntSet thisParameter = IntSetUtil.make(new int[1]);

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        int recvUse;
        if (receiver == null || receiver.length == 0 || !this.mayUnderstand(caller, site, callee, receiver[0])) {
            return null;
        }
        IR ir = caller.getIR();
        SSAAbstractInvokeInstruction[] invokeInstructions = ir.getCalls(site);
        if (invokeInstructions.length != 1) {
            return new ReceiverInstanceContext(receiver[0]);
        }
        SymbolTable st = ir.getSymbolTable();
        ConstantKey receiverConstantKey = (ConstantKey)receiver[0];
        IMethod m = (IMethod)receiverConstantKey.getValue();
        boolean isStatic = m.isStatic();
        boolean isConstructor = this.isConstructorConstant(receiver[0]);
        if (!isConstructor && st.isNullConstant(recvUse = invokeInstructions[0].getUse(1)) && !isStatic) {
            return null;
        }
        int numberOfParams = isStatic ? m.getNumberOfParameters() : m.getNumberOfParameters() - 1;
        int paramIndex = isConstructor ? 1 : 2;
        int paramUse = invokeInstructions[0].getUse(paramIndex);
        SSAInstruction instr = caller.getDU().getDef(paramUse);
        if (!(instr instanceof SSANewInstruction)) {
            return new ReceiverInstanceContext(receiver[0]);
        }
        SSANewInstruction newInstr = (SSANewInstruction)instr;
        if (!newInstr.getConcreteType().isArrayType()) {
            return null;
        }
        int vn = newInstr.getUse(0);
        try {
            int arrayLength = st.getIntValue(vn);
            if (arrayLength == numberOfParams) {
                return new ReceiverInstanceContext(receiver[0]);
            }
            return new IllegalArgumentExceptionContext();
        }
        catch (IllegalArgumentException e) {
            return new ReceiverInstanceContext(receiver[0]);
        }
    }

    private boolean mayUnderstand(CGNode caller, CallSiteReference site, IMethod targetMethod, InstanceKey instance) {
        return instance instanceof ConstantKey && (targetMethod.getReference().equals(ReflectiveInvocationInterpreter.METHOD_INVOKE) || this.isConstructorConstant(instance) && targetMethod.getReference().equals(ReflectiveInvocationInterpreter.CTOR_NEW_INSTANCE));
    }

    private boolean isConstructorConstant(InstanceKey instance) {
        ConstantKey c;
        return instance instanceof ConstantKey && (c = (ConstantKey)instance).getConcreteType().getReference().equals(TypeReference.JavaLangReflectConstructor);
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (site.isDispatch() || site.getDeclaredTarget().getNumberOfParameters() > 0) {
            return thisParameter;
        }
        return EmptyIntSet.instance;
    }
}

