/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.AbstractReflectionInterpreter;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.summaries.SyntheticIR;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveInvocationInterpreter
extends AbstractReflectionInterpreter {
    public static final MethodReference CTOR_NEW_INSTANCE = MethodReference.findOrCreate(TypeReference.JavaLangReflectConstructor, "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
    public static final MethodReference METHOD_INVOKE = MethodReference.findOrCreate(TypeReference.JavaLangReflectMethod, "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        ReceiverInstanceContext recv = (ReceiverInstanceContext)node.getContext();
        ConstantKey c = (ConstantKey)recv.getReceiver();
        IMethod m = (IMethod)c.getValue();
        IR result = this.makeIR(node.getMethod(), m, recv);
        return result;
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        assert (this.understands(node));
        return this.getIR(node).getInstructions().length;
    }

    @Override
    public boolean understands(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!(node.getContext() instanceof ReceiverInstanceContext)) {
            return false;
        }
        ReceiverInstanceContext r = (ReceiverInstanceContext)node.getContext();
        if (!(r.getReceiver() instanceof ConstantKey)) {
            return false;
        }
        return node.getMethod().getReference().equals(METHOD_INVOKE) || node.getMethod().getReference().equals(CTOR_NEW_INSTANCE);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        return this.getIR(node).iterateNewSites();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        assert (this.understands(node));
        return this.getIR(node).iterateCallSites();
    }

    private IR makeIR(IMethod method, IMethod target, ReceiverInstanceContext context) {
        SSAInstructionFactory insts = method.getDeclaringClass().getClassLoader().getInstructionFactory();
        AbstractReflectionInterpreter.SpecializedMethod m = (AbstractReflectionInterpreter)this.new AbstractReflectionInterpreter.SpecializedMethod(method, method.getDeclaringClass(), method.isStatic(), false);
        HashMap<Integer, ConstantValue> constants = HashMapFactory.make();
        int nextLocal = method.getNumberOfParameters() + 1;
        int nargs = target.getNumberOfParameters();
        int[] args = new int[nargs];
        int pc = 0;
        int parametersVn = -1;
        if (method.getReference().equals(CTOR_NEW_INSTANCE)) {
            TypeReference allocatedType = target.getDeclaringClass().getReference();
            args[0] = nextLocal++;
            m.addInstruction(allocatedType, insts.NewInstruction(args[0], NewSiteReference.make(pc++, allocatedType)), true);
            parametersVn = 2;
        } else {
            parametersVn = 3;
            if (!target.isStatic()) {
                args[0] = nextLocal++;
                TypeReference type = target.getParameterType(0);
                SSACheckCastInstruction cast = insts.CheckCastInstruction(args[0], 2, type, true);
                m.addInstruction(null, cast, false);
            }
        }
        int nextArg = target.isStatic() ? 0 : 1;
        int nextParameter = 0;
        int j = nextArg;
        while (j < nargs) {
            int indexConst = nextLocal++;
            constants.put(new Integer(indexConst), new ConstantValue(nextParameter++));
            int temp = nextLocal++;
            m.addInstruction(null, insts.ArrayLoadInstruction(temp, parametersVn, indexConst, TypeReference.JavaLangObject), false);
            ++pc;
            args[j] = nextLocal++;
            TypeReference type = target.getParameterType(j);
            SSACheckCastInstruction cast = insts.CheckCastInstruction(args[j], temp, type, true);
            m.addInstruction(null, cast, false);
            ++pc;
            ++j;
        }
        int exceptions = nextLocal++;
        int result = -1;
        if (method.getReference().equals(CTOR_NEW_INSTANCE)) {
            m.addInstruction(null, insts.InvokeInstruction(args, exceptions, CallSiteReference.make(pc++, target.getReference(), IInvokeInstruction.Dispatch.SPECIAL)), false);
            m.addInstruction(null, insts.ReturnInstruction(args[0], false), false);
        } else {
            IInvokeInstruction.Dispatch d;
            IInvokeInstruction.Dispatch dispatch = d = target.isStatic() ? IInvokeInstruction.Dispatch.STATIC : IInvokeInstruction.Dispatch.VIRTUAL;
            if (target.getReturnType().equals(TypeReference.Void)) {
                m.addInstruction(null, insts.InvokeInstruction(args, exceptions, CallSiteReference.make(pc++, target.getReference(), d)), false);
            } else {
                result = nextLocal++;
                m.addInstruction(null, insts.InvokeInstruction(result, args, exceptions, CallSiteReference.make(pc++, target.getReference(), d)), false);
                m.addInstruction(null, insts.ReturnInstruction(result, false), false);
            }
        }
        SSAInstruction[] instrs = new SSAInstruction[m.allInstructions.size()];
        m.allInstructions.toArray(instrs);
        return new SyntheticIR(method, context, new InducedCFG(instrs, method, context), instrs, SSAOptions.defaultOptions(), constants);
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        return EmptyIterator.instance();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode N) {
        return this.getIR(N).getControlFlowGraph();
    }

    @Override
    public DefUse getDU(CGNode node) {
        return new DefUse(this.getIR(node));
    }
}

