/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.reflection.JavaLangClassContextInterpreter;
import com.ibm.wala.analysis.reflection.JavaTypeContext;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import java.util.Collection;

class JavaLangClassContextSelector
implements ContextSelector {
    private static final Collection<MethodReference> UNDERSTOOD_METHOD_REFS = HashSetFactory.make();
    private static final IntSet thisParameter;

    static {
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_CONSTRUCTOR);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_CONSTRUCTORS);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_METHOD);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_METHODS);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_CONSTRUCTOR);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_CONSTRUCTORS);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_METHOD);
        UNDERSTOOD_METHOD_REFS.add(JavaLangClassContextInterpreter.GET_DECLARED_METHODS);
        thisParameter = IntSetUtil.make(new int[1]);
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] receiver) {
        if (receiver != null && receiver.length > 0 && this.mayUnderstand(caller, site, callee, receiver[0])) {
            return new JavaTypeContext(new PointType(this.getTypeConstant(receiver[0])));
        }
        return null;
    }

    private IClass getTypeConstant(InstanceKey instance) {
        ConstantKey c;
        if (instance instanceof ConstantKey && (c = (ConstantKey)instance).getValue() instanceof IClass) {
            return (IClass)c.getValue();
        }
        return null;
    }

    private boolean mayUnderstand(CGNode caller, CallSiteReference site, IMethod targetMethod, InstanceKey instance) {
        return UNDERSTOOD_METHOD_REFS.contains(targetMethod.getReference()) && this.getTypeConstant(instance) != null;
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        if (site.isDispatch() || site.getDeclaredTarget().getNumberOfParameters() > 0) {
            return thisParameter;
        }
        return EmptyIntSet.instance;
    }
}

