/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.reflection;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.warnings.Warning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractReflectionInterpreter
implements SSAContextInterpreter {
    protected static final boolean DEBUG = false;
    protected static final int CONE_BOUND = 10;
    protected int indexLocal = 100;
    protected final Map<TypeReference, Integer> typeIndexMap = HashMapFactory.make();
    protected AnalysisOptions options;
    protected AnalysisCache cache;

    protected int getLocalForType(TypeReference T) {
        Integer I = this.typeIndexMap.get(T);
        if (I == null) {
            I = new Integer(this.indexLocal += 2);
            this.typeIndexMap.put(T, I);
        }
        return I;
    }

    protected int getExceptionsForType(TypeReference T) {
        return this.getLocalForType(T) + 1;
    }

    protected int getCallSiteForType(TypeReference T) {
        return this.getLocalForType(T);
    }

    protected int getNewSiteForType(TypeReference T) {
        return this.getLocalForType(T) + 1;
    }

    protected TypeAbstraction typeRef2TypeAbstraction(IClassHierarchy cha, TypeReference type) {
        IClass klass = cha.lookupClass(type);
        if (klass != null) {
            return new ConeType(klass);
        }
        Assertions.UNREACHABLE(type.toString());
        return null;
    }

    protected static class IgnoreSerializableWarning
    extends Warning {
        private static final IgnoreSerializableWarning instance = new IgnoreSerializableWarning();

        protected IgnoreSerializableWarning() {
        }

        public String getMsg() {
            return this.getClass().toString();
        }

        public static IgnoreSerializableWarning create() {
            return instance;
        }
    }

    protected static class ManySubtypesWarning
    extends Warning {
        final int nImplementors;
        final TypeAbstraction T;

        ManySubtypesWarning(TypeAbstraction T, int nImplementors) {
            super((byte)1);
            this.T = T;
            this.nImplementors = nImplementors;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T + " " + this.nImplementors;
        }

        public static ManySubtypesWarning create(TypeAbstraction T, int n) {
            return new ManySubtypesWarning(T, n);
        }
    }

    protected static class NoSubtypesWarning
    extends Warning {
        final TypeAbstraction T;

        NoSubtypesWarning(TypeAbstraction T) {
            super((byte)2);
            this.T = T;
        }

        public String getMsg() {
            return String.valueOf(this.getClass().toString()) + " : " + this.T;
        }

        public static NoSubtypesWarning create(TypeAbstraction T) {
            return new NoSubtypesWarning(T);
        }
    }

    protected class SpecializedMethod
    extends SyntheticMethod {
        protected final HashSet<TypeReference> typesAllocated;
        protected final ArrayList<SSAInstruction> allocations;
        protected final ArrayList<SSAInstruction> calls;
        protected final ArrayList<SSAInstruction> allInstructions;
        private final SSAInstructionFactory insts;

        public SpecializedMethod(MethodReference method, IClass declaringClass, boolean isStatic, boolean isFactory) {
            super(method, declaringClass, isStatic, isFactory);
            this.typesAllocated = HashSetFactory.make(5);
            this.allocations = new ArrayList();
            this.calls = new ArrayList();
            this.allInstructions = new ArrayList();
            this.insts = this.declaringClass.getClassLoader().getInstructionFactory();
        }

        public SpecializedMethod(IMethod method, IClass declaringClass, boolean isStatic, boolean isFactory) {
            super(method, declaringClass, isStatic, isFactory);
            this.typesAllocated = HashSetFactory.make(5);
            this.allocations = new ArrayList();
            this.calls = new ArrayList();
            this.allInstructions = new ArrayList();
            this.insts = this.declaringClass.getClassLoader().getInstructionFactory();
        }

        protected void addInstruction(TypeReference T, SSAInstruction instr, boolean isAllocation) {
            if (isAllocation) {
                if (this.typesAllocated.contains(T)) {
                    return;
                }
                this.typesAllocated.add(T);
            }
            this.allInstructions.add(instr);
            if (isAllocation) {
                this.allocations.add(instr);
            }
        }

        protected int addStatementsForConcreteSimpleType(TypeReference t) {
            assert (!this.typesAllocated.contains(t));
            NewSiteReference ref = NewSiteReference.make(AbstractReflectionInterpreter.this.getNewSiteForType(t), t);
            int alloc = AbstractReflectionInterpreter.this.getLocalForType(t);
            if (t.isArrayType()) {
                int dim = t.getDimensionality();
                int[] extents = new int[dim];
                Arrays.fill(extents, 1);
                SSANewInstruction a = this.insts.NewInstruction(alloc, ref, extents);
                this.addInstruction(t, a, true);
            } else {
                SSANewInstruction a = this.insts.NewInstruction(alloc, ref);
                this.addInstruction(t, a, true);
                this.addCtorInvokeInstruction(t, alloc);
            }
            SSAReturnInstruction r = this.insts.ReturnInstruction(alloc, false);
            this.addInstruction(t, r, false);
            return alloc;
        }

        protected void addCtorInvokeInstruction(TypeReference t, int alloc) {
            MethodReference init = MethodReference.findOrCreate(t, MethodReference.initAtom, MethodReference.defaultInitDesc);
            CallSiteReference site = CallSiteReference.make(AbstractReflectionInterpreter.this.getCallSiteForType(t), init, IInvokeInstruction.Dispatch.SPECIAL);
            int[] params = new int[]{alloc};
            int exc = AbstractReflectionInterpreter.this.getExceptionsForType(t);
            SSAInvokeInstruction s = this.insts.InvokeInstruction(params, exc, site);
            this.calls.add(s);
            this.allInstructions.add(s);
        }
    }
}

