/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.pointers;

import com.ibm.wala.analysis.pointers.HeapGraph;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.IntMapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.IntFunction;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicHeapGraph
extends HeapGraph {
    private static final boolean VERBOSE = false;
    private static final int VERBOSE_INTERVAL = 10000;
    private static final MutableSparseIntSetFactory factory = new MutableSparseIntSetFactory();
    private final NumberedGraph<Object> G;
    private final CallGraph callGraph;

    public BasicHeapGraph(final PointerAnalysis P, CallGraph callGraph) throws NullPointerException {
        super(P);
        this.callGraph = callGraph;
        final OrdinalSetMapping<PointerKey> pointerKeys = this.getPointerKeys();
        final NumberedNodeManager<Object> nodeMgr = new NumberedNodeManager<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new CompoundIterator<Object>(pointerKeys.iterator(), P.getInstanceKeyMapping().iterator());
            }

            @Override
            public int getNumberOfNodes() {
                return pointerKeys.getSize() + P.getInstanceKeyMapping().getSize();
            }

            @Override
            public void addNode(Object n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(Object n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public int getNumber(Object N) {
                int inumber;
                if (N instanceof PointerKey) {
                    return pointerKeys.getMappedIndex((PointerKey)N);
                }
                if (!(N instanceof InstanceKey)) {
                    Assertions.UNREACHABLE(N.getClass().toString());
                }
                return (inumber = P.getInstanceKeyMapping().getMappedIndex((InstanceKey)N)) == -1 ? -1 : inumber + pointerKeys.getMaximumIndex() + 1;
            }

            @Override
            public Object getNode(int number) {
                if (number > pointerKeys.getMaximumIndex()) {
                    return P.getInstanceKeyMapping().getMappedObject(number - pointerKeys.getSize());
                }
                return pointerKeys.getMappedObject(number);
            }

            @Override
            public int getMaxNumber() {
                return this.getNumberOfNodes() - 1;
            }

            @Override
            public boolean containsNode(Object n) {
                return this.getNumber(n) != -1;
            }

            @Override
            public Iterator<Object> iterateNodes(IntSet s) {
                return new NumberedNodeIterator<Object>(s, this);
            }
        };
        IBinaryNaturalRelation pred = this.computePredecessors(nodeMgr);
        IntFunction<Object> toNode = new IntFunction<Object>(){

            @Override
            public Object apply(int i) {
                return nodeMgr.getNode(i);
            }
        };
        this.G = new AbstractNumberedGraph<Object>(pred, (IntFunction)toNode){
            private final NumberedEdgeManager<Object> edgeMgr;
            {
                this.edgeMgr = new NumberedEdgeManager<Object>(){

                    @Override
                    public Iterator<Object> getPredNodes(Object N) {
                        int n = numberedNodeManager.getNumber(N);
                        IntSet p = iBinaryNaturalRelation.getRelated(n);
                        if (p == null) {
                            return EmptyIterator.instance();
                        }
                        return new IntMapIterator<Object>(p.intIterator(), intFunction);
                    }

                    @Override
                    public IntSet getPredNodeNumbers(Object N) {
                        int n = numberedNodeManager.getNumber(N);
                        IntSet p = iBinaryNaturalRelation.getRelated(n);
                        if (p != null) {
                            return p;
                        }
                        return IntSetUtil.make();
                    }

                    @Override
                    public int getPredNodeCount(Object N) {
                        int n = numberedNodeManager.getNumber(N);
                        return iBinaryNaturalRelation.getRelatedCount(n);
                    }

                    @Override
                    public Iterator<Object> getSuccNodes(Object N) {
                        int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, numberedNodeManager);
                        if (succ == null) {
                            return EmptyIterator.instance();
                        }
                        MutableSparseIntSet s = factory.make(succ);
                        return new IntMapIterator<Object>(s.intIterator(), intFunction);
                    }

                    @Override
                    public IntSet getSuccNodeNumbers(Object N) {
                        int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, numberedNodeManager);
                        if (succ == null) {
                            return IntSetUtil.make();
                        }
                        return IntSetUtil.make(succ);
                    }

                    @Override
                    public int getSuccNodeCount(Object N) {
                        int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, numberedNodeManager);
                        return succ == null ? 0 : succ.length;
                    }

                    @Override
                    public void addEdge(Object src, Object dst) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeEdge(Object src, Object dst) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeAllIncidentEdges(Object node) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeIncomingEdges(Object node) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public void removeOutgoingEdges(Object node) {
                        Assertions.UNREACHABLE();
                    }

                    @Override
                    public boolean hasEdge(Object src, Object dst) {
                        Assertions.UNREACHABLE();
                        return false;
                    }
                };
            }

            @Override
            protected NumberedNodeManager<Object> getNodeManager() {
                return nodeMgr;
            }

            @Override
            protected NumberedEdgeManager<Object> getEdgeManager() {
                return this.edgeMgr;
            }
        };
    }

    private OrdinalSetMapping<PointerKey> getPointerKeys() {
        MutableMapping<PointerKey> result = MutableMapping.make();
        for (PointerKey p : this.getPointerAnalysis().getPointerKeys()) {
            result.add(p);
        }
        return result;
    }

    private int[] computeSuccNodeNumbers(Object N, NumberedNodeManager<Object> nodeManager) {
        if (N instanceof PointerKey) {
            PointerKey P = (PointerKey)N;
            OrdinalSet<InstanceKey> S = this.getPointerAnalysis().getPointsToSet(P);
            int[] result = new int[S.size()];
            int i = 0;
            Iterator<InstanceKey> it = S.iterator();
            while (it.hasNext()) {
                result[i] = nodeManager.getNumber(it.next());
                ++i;
            }
            return result;
        }
        if (N instanceof InstanceKey) {
            InstanceKey I = (InstanceKey)N;
            TypeReference T = I.getConcreteType().getReference();
            if (T == null) assert (T != null) : "null concrete type from " + I.getClass();
            if (T.isArrayType()) {
                PointerKey p = this.getHeapModel().getPointerKeyForArrayContents(I);
                if (p == null || !nodeManager.containsNode(p)) {
                    return null;
                }
                return new int[]{nodeManager.getNumber(p)};
            }
            IClass klass = this.getHeapModel().getClassHierarchy().lookupClass(T);
            if (klass == null) assert (klass != null) : "null klass for type " + T;
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            for (IField f : klass.getAllInstanceFields()) {
                PointerKey p;
                if (f.getReference().getFieldType().isPrimitiveType() || (p = this.getHeapModel().getPointerKeyForInstanceField(I, f)) == null || !nodeManager.containsNode(p)) continue;
                result.add(nodeManager.getNumber(p));
            }
            return result.toIntArray();
        }
        Assertions.UNREACHABLE("Unexpected type: " + N.getClass());
        return null;
    }

    private IBinaryNaturalRelation computePredecessors(NumberedNodeManager<Object> nodeManager) {
        BasicNaturalRelation R = new BasicNaturalRelation(new byte[1], 0);
        this.computePredecessorsForNonLocals(nodeManager, R);
        this.computePredecessorsForLocals(nodeManager, R);
        return R;
    }

    private void computePredecessorsForNonLocals(NumberedNodeManager<Object> nodeManager, BasicNaturalRelation R) {
        int i = nodeManager.getMaxNumber();
        while (i >= 0) {
            int[] succ;
            Object n = nodeManager.getNode(i);
            if (!(n instanceof LocalPointerKey) && (succ = this.computeSuccNodeNumbers(n, nodeManager)) != null) {
                int z = 0;
                while (z < succ.length) {
                    int j = succ[z];
                    R.add(j, i);
                    ++z;
                }
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computePredecessorsForLocals(NumberedNodeManager<Object> nodeManager, BasicNaturalRelation R) {
        void var5_7;
        ArrayList<LocalPointerKey> list = new ArrayList<LocalPointerKey>();
        for (Object t : nodeManager) {
            if (!(t instanceof LocalPointerKey)) continue;
            list.add((LocalPointerKey)t);
        }
        Object[] arr = list.toArray();
        Arrays.sort(arr, new LocalPointerComparator());
        boolean bl = false;
        while (var5_7 < arr.length) {
            LocalPointerKey n = (LocalPointerKey)arr[var5_7];
            int num = nodeManager.getNumber(n);
            int[] succ = this.computeSuccNodeNumbers(n, nodeManager);
            if (succ != null) {
                int z = 0;
                while (z < succ.length) {
                    int j = succ[z];
                    R.add(j, num);
                    ++z;
                }
            }
            ++var5_7;
        }
    }

    @Override
    public int getNumber(Object N) {
        return this.G.getNumber(N);
    }

    @Override
    public Object getNode(int number) {
        return this.G.getNode(number);
    }

    @Override
    public int getMaxNumber() {
        return this.G.getMaxNumber();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.G.iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.G.getNumberOfNodes();
    }

    @Override
    public Iterator<Object> getPredNodes(Object N) {
        return this.G.getPredNodes(N);
    }

    @Override
    public int getPredNodeCount(Object N) {
        return this.G.getPredNodeCount(N);
    }

    @Override
    public Iterator<Object> getSuccNodes(Object N) {
        return this.G.getSuccNodes(N);
    }

    @Override
    public int getSuccNodeCount(Object N) {
        return this.G.getSuccNodeCount(N);
    }

    @Override
    public void addNode(Object n) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeNode(Object n) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean hasEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void removeAllIncidentEdges(Object node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(Object N) {
        return this.G.containsNode(N);
    }

    public String toString() {
        Object node;
        StringBuffer result = new StringBuffer();
        result.append("Nodes:\n");
        int i = 0;
        while (i <= this.getMaxNumber()) {
            node = this.getNode(i);
            if (node != null) {
                result.append(i).append("  ").append(node).append("\n");
            }
            ++i;
        }
        result.append("Edges:\n");
        i = 0;
        while (i <= this.getMaxNumber()) {
            node = this.getNode(i);
            if (node != null) {
                result.append(i).append(" -> ");
                Iterator<Object> it = this.getSuccNodes(node);
                while (it.hasNext()) {
                    Object s = it.next();
                    result.append(this.getNumber(s)).append(" ");
                }
                result.append("\n");
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public void removeIncomingEdges(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public IntSet getSuccNodeNumbers(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LocalPointerComparator
    implements Comparator<Object> {
        private LocalPointerComparator() {
        }

        @Override
        public int compare(Object arg1, Object arg2) {
            LocalPointerKey o1 = (LocalPointerKey)arg1;
            LocalPointerKey o2 = (LocalPointerKey)arg2;
            if (o1.getNode().equals(o2.getNode())) {
                return o1.getValueNumber() - o2.getValueNumber();
            }
            return BasicHeapGraph.this.callGraph.getNumber(o1.getNode()) - BasicHeapGraph.this.callGraph.getNumber(o2.getNode());
        }
    }
}

